/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n7 = 0;
        n7 = OS.GTK_VERSION >= OS.VERSION(3, 4, 0) ? OS.gtk_color_chooser_dialog_new(byArray, this.parent.topHandle()) : OS.gtk_color_selection_dialog_new(byArray);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        int n8 = 0;
        GdkColor gdkColor = new GdkColor();
        GdkRGBA gdkRGBA = new GdkRGBA();
        if (OS.GTK_VERSION <= OS.VERSION(3, 4, 0)) {
            if (this.parent != null) {
                n6 = this.parent.topHandle();
                OS.gtk_window_set_transient_for(n7, n6);
                n5 = OS.gtk_window_get_icon_list(n6);
                if (n5 != 0) {
                    OS.gtk_window_set_icon_list(n7, n5);
                    OS.g_list_free(n5);
                }
            }
            n6 = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(n6, n7);
            OS.gtk_window_set_modal(n7, true);
            if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
                n8 = OS.gtk_color_selection_dialog_get_color_selection(n7);
            } else {
                GtkColorSelectionDialog gtkColorSelectionDialog = new GtkColorSelectionDialog();
                OS.memmove(gtkColorSelectionDialog, n7);
                n8 = gtkColorSelectionDialog.colorsel;
            }
            if (this.rgb != null) {
                gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
                gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
                gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
                OS.gtk_color_selection_set_current_color(n8, gdkColor);
            }
            OS.gtk_color_selection_set_has_palette(n8, true);
        } else {
            if (this.rgb != null) {
                gdkRGBA.red = (double)this.rgb.red / 255.0;
                gdkRGBA.green = (double)this.rgb.green / 255.0;
                gdkRGBA.blue = (double)this.rgb.blue / 255.0;
            }
            OS.gtk_color_chooser_set_use_alpha(n7, false);
            OS.gtk_color_chooser_set_rgba(n7, gdkRGBA);
        }
        if (this.rgbs != null) {
            n6 = OS.g_malloc(GdkColor.sizeof * this.rgbs.length);
            for (n5 = 0; n5 < this.rgbs.length; ++n5) {
                RGB rGB = this.rgbs[n5];
                if (rGB == null) continue;
                gdkColor.red = (short)(rGB.red & 0xFF | (rGB.red & 0xFF) << 8);
                gdkColor.green = (short)(rGB.green & 0xFF | (rGB.green & 0xFF) << 8);
                gdkColor.blue = (short)(rGB.blue & 0xFF | (rGB.blue & 0xFF) << 8);
                OS.memmove(n6 + n5 * GdkColor.sizeof, gdkColor, GdkColor.sizeof);
            }
            n5 = OS.gtk_color_selection_palette_to_string(n6, this.rgbs.length);
            n4 = OS.strlen(n5);
            byArray = new byte[n4];
            OS.memmove(byArray, n5, n4);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            byArray = Converter.wcsToMbcs(null, string, true);
            OS.g_free(n6);
            n3 = OS.gtk_settings_get_default();
            if (n3 != 0) {
                OS.gtk_settings_set_string_property(n3, OS.gtk_color_palette, byArray, Converter.wcsToMbcs(null, "gtk_color_selection_palette_to_string", true));
            }
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(n7)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        n5 = 0;
        n4 = 0;
        if ((this.style & 0x4000000) != 0) {
            n5 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n4 = OS.g_signal_add_emission_hook(n5, 0, display.emissionProc, n7, 0);
        }
        int n9 = OS.gtk_dialog_run(n7);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n5, n4);
        }
        if (OS.gtk_window_get_modal(n7)) {
            display.setModalDialog(dialog);
        }
        int n10 = n3 = n9 == -5 ? 1 : 0;
        if (n3 != 0) {
            n2 = 0;
            int n11 = 0;
            n = 0;
            if (OS.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                OS.gtk_color_chooser_get_rgba(n7, gdkRGBA);
                n2 = (int)(gdkRGBA.red * 255.0);
                n11 = (int)(gdkRGBA.green * 255.0);
                n = (int)(gdkRGBA.blue * 255.0);
            } else {
                OS.gtk_color_selection_get_current_color(n8, gdkColor);
                n2 = gdkColor.red >> 8 & 0xFF;
                n11 = gdkColor.green >> 8 & 0xFF;
                n = gdkColor.blue >> 8 & 0xFF;
            }
            this.rgb = new RGB(n2, n11, n);
        }
        if ((n2 = OS.gtk_settings_get_default()) != 0) {
            int[] nArray = new int[1];
            OS.g_object_get(n2, OS.gtk_color_palette, nArray, 0);
            if (nArray[0] != 0) {
                n = OS.strlen(nArray[0]);
                byArray = new byte[n];
                OS.memmove(byArray, nArray[0], n);
                OS.g_free(nArray[0]);
                String[] stringArray = null;
                if (n > 0) {
                    String string = new String(Converter.mbcsToWcs(null, byArray));
                    stringArray = ColorDialog.splitString(string, ':');
                    n = stringArray.length;
                }
                this.rgbs = new RGB[n];
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    byArray = Converter.wcsToMbcs(null, string, true);
                    OS.gdk_color_parse(byArray, gdkColor);
                    int n12 = gdkColor.red >> 8 & 0xFF;
                    int n13 = gdkColor.green >> 8 & 0xFF;
                    int n14 = gdkColor.blue >> 8 & 0xFF;
                    this.rgbs[i] = new RGB(n12, n13, n14);
                }
            }
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(n7);
        if (n3 == 0) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

