/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    static int checkStyle(int n) {
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int childStyle() {
        int n = OS.gtk_widget_get_modifier_style(this.handle);
        if ((OS.gtk_rc_style_get_color_flags(n, 0) & 2) != 0) {
            return 0;
        }
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_widget_get_style(this.handle);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int clientHandle() {
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n != -1 && this.items[n] != null) {
            return this.items[n].pageHandle;
        }
        return this.handle;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n, n2, bl);
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        boolean bl2 = OS.gtk_notebook_get_scrollable(this.handle);
        OS.gtk_notebook_set_scrollable(this.handle, false);
        Point point2 = this.computeNativeSize(this.handle, n, n2, bl);
        OS.gtk_notebook_set_scrollable(this.handle, bl2);
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0)) {
            int[] nArray = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.initial_gap, nArray, 0);
            point2.x += nArray[0] * 2;
        }
        point.x = Math.max(point2.x, point.x);
        point.y = Math.max(point2.y, point.y);
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.forceResize();
        int n5 = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(n5, gtkAllocation);
        int n6 = gtkAllocation.x;
        int n7 = gtkAllocation.y;
        n -= n6;
        n2 -= n7;
        n3 += n6 + n6;
        if ((this.style & 0x400) != 0) {
            int n8 = gtkAllocation.height;
            this.gtk_widget_get_allocation(this.handle, gtkAllocation);
            int n9 = gtkAllocation.height;
            n4 += n9 - n8;
        } else {
            n4 += n6 + n7;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_notebook_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_notebook_set_show_tabs(this.handle, true);
        OS.gtk_notebook_set_scrollable(this.handle, true);
        if ((this.style & 0x400) != 0) {
            OS.gtk_notebook_set_tab_pos(this.handle, 3);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TabItem[4];
    }

    void createItem(TabItem tabItem, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = OS.gtk_container_get_children(this.handle);
        int n6 = 0;
        if (n5 != 0) {
            n6 = OS.g_list_length(n5);
            OS.g_list_free(n5);
        }
        if (0 > n || n > n6) {
            this.error(6);
        }
        if (n6 == this.items.length) {
            TabItem[] tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if ((n4 = this.gtk_box_new(0, false, 0)) == 0) {
            this.error(2);
        }
        if ((n3 = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((n2 = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add(n4, n2);
        OS.gtk_container_add(n4, n3);
        int n7 = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (n7 == 0) {
            this.error(2);
        }
        if (OS.GTK3) {
            OS.gtk_widget_override_background_color(n7, 0, new GdkRGBA());
            int n8 = OS.gdk_region_new();
            OS.gtk_widget_input_shape_combine_region(n7, n8);
            OS.gdk_region_destroy(n8);
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 49);
        OS.gtk_notebook_insert_page(this.handle, n7, n4, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 49);
        OS.gtk_widget_show(n4);
        OS.gtk_widget_show(n3);
        OS.gtk_widget_show(n7);
        tabItem.state |= 8;
        tabItem.handle = n4;
        tabItem.labelHandle = n3;
        tabItem.imageHandle = n2;
        tabItem.pageHandle = n7;
        System.arraycopy(this.items, n, this.items, n + 1, n6++ - n);
        this.items[n] = tabItem;
        if ((this.state & 0x1000) != 0) {
            tabItem.setForegroundColor(this.getForegroundColor());
        }
        if ((this.state & 0x4000) != 0) {
            tabItem.setFontDescription(this.getFontDescription());
        }
        if (n6 == 1) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 49);
            OS.gtk_notebook_set_current_page(this.handle, 0);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 49);
            Event event = new Event();
            event.item = this.items[0];
            this.sendSelectionEvent(13, event, false);
        }
    }

    void destroyItem(TabItem tabItem) {
        int n;
        int n2;
        int n3 = this.getItemCount();
        for (n2 = 0; n2 < n3 && this.items[n2] != tabItem; ++n2) {
        }
        if (n2 == n3) {
            this.error(15);
        }
        int n4 = OS.gtk_notebook_get_current_page(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 49);
        OS.gtk_notebook_remove_page(this.handle, n2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 49);
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
        this.items[n3] = null;
        if (n2 == n4 && (n = OS.gtk_notebook_get_current_page(this.handle)) != -1) {
            Control control = this.items[n].getControl();
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            Event event = new Event();
            event.item = this.items[n];
            this.sendSelectionEvent(13, event, true);
        }
    }

    int eventHandle() {
        return this.handle;
    }

    public TabItem getItem(int n) {
        int n2;
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        if ((n2 = OS.gtk_container_get_children(this.handle)) == 0) {
            this.error(8);
        }
        int n3 = OS.g_list_length(n2);
        OS.g_list_free(n2);
        if (0 > n || n >= n3) {
            this.error(8);
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        int n;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((n = OS.gtk_container_get_children(this.handle)) == 0) {
            return null;
        }
        int n2 = OS.g_list_length(n);
        OS.g_list_free(n);
        for (int i = 0; i < n2; ++i) {
            TabItem tabItem = this.items[i];
            Rectangle rectangle = tabItem.getBounds();
            if (!rectangle.contains(point)) continue;
            return tabItem;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return 0;
        }
        int n2 = OS.g_list_length(n);
        OS.g_list_free(n);
        return n2;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = OS.gtk_notebook_get_current_page(this.handle);
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_notebook_get_current_page(this.handle);
    }

    int gtk_focus(int n, int n2) {
        return 0;
    }

    int gtk_switch_page(int n, int n2, int n3) {
        Control control;
        Widget widget;
        int n4 = OS.gtk_notebook_get_current_page(this.handle);
        if (n4 != -1 && (widget = this.items[n4].getControl()) != null && !widget.isDisposed()) {
            ((Control)widget).setVisible(false);
        }
        if ((control = ((TabItem)(widget = this.items[n3])).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        Event event = new Event();
        event.item = widget;
        this.sendSelectionEvent(13, event, false);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.switch_page, this.display.getClosure(49), false);
    }

    public int indexOf(TabItem tabItem) {
        int n;
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        if ((n = OS.gtk_container_get_children(this.handle)) == 0) {
            return -1;
        }
        int n2 = OS.g_list_length(n);
        OS.g_list_free(n);
        for (int i = 0; i < n2; ++i) {
            if (this.items[i] != tabItem) continue;
            return i;
        }
        return -1;
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            SerializableCompatibility serializableCompatibility;
            Control control = controlArray[i];
            int n5 = 0;
            int n6 = 0;
            int n7 = OS.gtk_container_get_children(this.handle);
            if (n7 != 0) {
                n6 = OS.g_list_length(n7);
                OS.g_list_free(n7);
            }
            while (n5 < n6 && this.items[n5].control != control) {
                ++n5;
            }
            if (n5 == n6) {
                serializableCompatibility = control.getBounds();
                n3 = Math.max(n3, serializableCompatibility.x + serializableCompatibility.width);
                n4 = Math.max(n4, serializableCompatibility.y + serializableCompatibility.height);
                continue;
            }
            serializableCompatibility = control.computeSize(n, n2, bl);
            n3 = Math.max(n3, ((Point)serializableCompatibility).x);
            n4 = Math.max(n4, ((Point)serializableCompatibility).y);
        }
        return new Point(n3, n4);
    }

    boolean mnemonicHit(char c) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.items[i].labelHandle;
            if (n2 == 0 || !this.mnemonicHit(n2, c)) continue;
            return true;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.items[i].labelHandle;
            if (n2 == 0 || !this.mnemonicHit(n2, c)) continue;
            return true;
        }
        return false;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null || tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            TabItem tabItem = this.items[i];
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void reskinChildren(int n) {
        int n2;
        if (this.items != null && (n2 = OS.gtk_container_get_children(this.handle)) != 0) {
            int n3 = OS.g_list_length(n2);
            OS.g_list_free(n2);
            for (int i = 0; i < n3; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null) continue;
                tabItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n6 & 0x100) != 0 && (n5 = this.getSelectionIndex()) != -1) {
            TabItem tabItem = this.items[n5];
            Control control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return n6;
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        TabItem[] tabItemArray = this.getItems();
        for (int i = 0; i < tabItemArray.length; ++i) {
            if (tabItemArray[i] == null) continue;
            tabItemArray[i].setFontDescription(n);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        TabItem[] tabItemArray = this.getItems();
        for (int i = 0; i < tabItemArray.length; ++i) {
            if (tabItemArray[i] == null) continue;
            tabItemArray[i].setForegroundColor(gdkColor);
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.items[i].setOrientation(bl);
            }
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            return;
        }
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Widget widget;
        if (n < 0) {
            return;
        }
        int n2 = OS.gtk_notebook_get_current_page(this.handle);
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            TabItem tabItem = this.items[n2];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 49);
        OS.gtk_notebook_set_current_page(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 49);
        int n3 = OS.gtk_notebook_get_current_page(this.handle);
        if (n3 != -1) {
            widget = this.items[n3];
            Control control = ((TabItem)widget).control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = widget;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    public void setSelection(TabItem tabItem) {
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            for (int i = tabItemArray.length - 1; i >= 0; --i) {
                int n = this.indexOf(tabItemArray[i]);
                if (n == -1) continue;
                this.setSelection(n, false);
            }
        }
    }

    boolean traversePage(boolean bl) {
        if (bl) {
            OS.gtk_notebook_next_page(this.handle);
        } else {
            OS.gtk_notebook_prev_page(this.handle);
        }
        return true;
    }
}

