/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSearchField;
import org.eclipse.swt.internal.cocoa.NSSearchFieldCell;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSUndoManager;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTSearchField;
import org.eclipse.swt.internal.cocoa.SWTSecureTextField;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.internal.cocoa.SWTTextView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int textLimit = LIMIT;
    int tabs = 8;
    char echoCharacter;
    boolean doubleClick;
    boolean receivingFocus;
    char[] hiddenText;
    String message;
    NSRange selectionRange;
    id targetSearch;
    id targetCancel;
    long actionSearch;
    long actionCancel;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r";
    static final char PASSWORD = '\u2022';

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
        if ((n & 0x80) != 0) {
            NSButtonCell nSButtonCell;
            NSSearchFieldCell nSSearchFieldCell = new NSSearchFieldCell(((NSSearchField)this.view).cell());
            if ((n & 0x100) != 0) {
                this.style |= 0x100;
                nSButtonCell = nSSearchFieldCell.cancelButtonCell();
                this.targetCancel = nSButtonCell.target();
                this.actionCancel = nSButtonCell.action();
                nSButtonCell.setTarget(this.view);
                nSButtonCell.setAction(OS.sel_sendCancelSelection);
            } else {
                nSSearchFieldCell.setCancelButtonCell(null);
            }
            if ((n & 0x200) != 0) {
                this.style |= 0x200;
                nSButtonCell = nSSearchFieldCell.searchButtonCell();
                this.targetSearch = nSButtonCell.target();
                this.actionSearch = nSButtonCell.action();
                nSButtonCell.setTarget(this.view);
                nSButtonCell.setAction(OS.sel_sendSearchSelection);
            } else {
                nSSearchFieldCell.setSearchButtonCell(null);
            }
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, n = this.getCharCount(), n, null)) == null) {
            return;
        }
        if ((this.style & 4) != 0) {
            this.setSelection(this.getCharCount());
            this.insertEditText(string);
        } else {
            NSString nSString = this.textLimit != LIMIT ? this.getInsertString(string, null) : NSString.stringWith(string);
            NSTextView nSTextView = (NSTextView)this.view;
            NSTextStorage nSTextStorage = nSTextView.textStorage();
            NSRange nSRange = new NSRange();
            nSRange.location = nSTextStorage.length();
            nSTextStorage.replaceCharactersInRange(nSRange, nSString);
            nSRange.location = nSTextStorage.length();
            nSTextView.scrollRangeToVisible(nSRange);
            nSTextView.setSelectedRange(nSRange);
        }
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    boolean becomeFirstResponder(long l, long l2) {
        this.receivingFocus = true;
        boolean bl = super.becomeFirstResponder(l, l2);
        this.receivingFocus = false;
        return bl;
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        Point point = this.getSelection();
        this.setSelection(point.x);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 4) != 0) {
            NSCell nSCell = ((NSTextField)this.view).cell();
            NSSize nSSize = nSCell.cellSize();
            NSString nSString = ((NSTextField)this.view).stringValue();
            if (nSString.length() > 0L) {
                n3 = (int)Math.ceil(nSSize.width);
            }
            n4 = (int)Math.ceil(nSSize.height);
            Point point = null;
            if ((this.style & 0x800) != 0 && (n != -1 || n2 != -1)) {
                NSRect nSRect = nSCell.titleRectForBounds(new NSRect());
                point = new Point(-((int)Math.ceil(nSRect.width)), -((int)Math.ceil(nSRect.height)));
                n3 -= point.x;
                n4 -= point.y;
            }
            if (n3 <= 0) {
                n3 = 64;
            }
            if (n4 <= 0) {
                n4 = 64;
            }
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            if (point != null) {
                n3 += point.x;
                n4 += point.y;
            }
        } else {
            NSLayoutManager nSLayoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            NSTextContainer nSTextContainer = (NSTextContainer)new NSTextContainer().alloc();
            NSSize nSSize = new NSSize();
            nSSize.height = 5000000.0;
            nSSize.width = 5000000.0;
            if ((this.style & 0x40) != 0) {
                if (n != -1) {
                    nSSize.width = n;
                }
                if (n2 != -1) {
                    nSSize.height = n2;
                }
            }
            nSTextContainer.initWithContainerSize(nSSize);
            nSLayoutManager.addTextContainer(nSTextContainer);
            NSTextStorage nSTextStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            nSTextStorage.setAttributedString(((NSTextView)this.view).textStorage());
            nSLayoutManager.setTextStorage(nSTextStorage);
            nSLayoutManager.glyphRangeForTextContainer(nSTextContainer);
            NSRect nSRect = nSLayoutManager.usedRectForTextContainer(nSTextContainer);
            n3 = nSLayoutManager.numberOfGlyphs() == 0L ? 64 : (int)Math.ceil(nSRect.width);
            n4 = (int)Math.ceil(nSRect.height);
            nSTextStorage.release();
            nSTextContainer.release();
            nSLayoutManager.release();
            if (n3 <= 0) {
                n3 = 64;
            }
            if (n4 <= 0) {
                n4 = 64;
            }
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        return new Point(n3, n4);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        if ((this.style & 4) != 0) {
            Object object;
            NSTextField nSTextField = (NSTextField)this.view;
            if ((this.style & 0x80) != 0) {
                object = new NSSearchFieldCell(nSTextField.cell());
                int n5 = 100;
                NSRect nSRect = new NSRect();
                nSRect.width = n5;
                nSRect = ((NSSearchFieldCell)object).searchTextRectForBounds(nSRect);
                int n6 = (int)nSRect.x;
                int n7 = n5 - n6 - (int)Math.ceil(nSRect.width);
                rectangle.x -= n6;
                rectangle.width += n6 + n7;
            }
            object = nSTextField.cell().titleRectForBounds(new NSRect());
            rectangle.x = (int)((double)rectangle.x - ((NSRect)object).x);
            rectangle.y = (int)((double)rectangle.y - ((NSRect)object).y);
            rectangle.width = (int)((double)rectangle.width - ((NSRect)object).width);
            rectangle.height = (int)((double)rectangle.height - ((NSRect)object).height);
        }
        return rectangle;
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0 || this.echoCharacter != '\u0000') {
            return;
        }
        if ((this.style & 4) != 0) {
            Point point = this.getSelection();
            if (point.x == point.y) {
                return;
            }
            this.copyToClipboard(this.getEditText(point.x, point.y - 1));
        } else {
            NSText nSText = (NSText)this.view;
            if (nSText.selectedRange().length == 0L) {
                return;
            }
            nSText.copy(null);
        }
    }

    void createHandle() {
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x800;
        }
        if ((this.style & 4) != 0) {
            NSTextField nSTextField = (this.style & 0x400000) != 0 ? (NSTextField)new SWTSecureTextField().alloc() : ((this.style & 0x80) != 0 ? (NSTextField)new SWTSearchField().alloc() : (NSTextField)new SWTTextField().alloc());
            nSTextField.init();
            nSTextField.setSelectable(true);
            nSTextField.setEditable((this.style & 8) == 0);
            if ((this.style & 0x800) == 0) {
                nSTextField.setFocusRingType(1L);
                nSTextField.setBordered(false);
            }
            int n = 0;
            if ((this.style & 0x1000000) != 0) {
                n = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n = 1;
            }
            nSTextField.setAlignment(n);
            NSCell nSCell = nSTextField.cell();
            nSCell.setWraps(false);
            nSCell.setScrollable(true);
            this.view = nSTextField;
        } else {
            NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
            nSScrollView.init();
            nSScrollView.setHasVerticalScroller((this.style & 0x200) != 0);
            nSScrollView.setHasHorizontalScroller((this.style & 0x100) != 0);
            nSScrollView.setAutoresizesSubviews(true);
            if ((this.style & 0x800) != 0) {
                nSScrollView.setBorderType(2L);
            }
            NSTextView nSTextView = (NSTextView)new SWTTextView().alloc();
            nSTextView.init();
            nSTextView.setEditable((this.style & 8) == 0);
            nSTextView.setAllowsUndo(true);
            NSSize nSSize = new NSSize();
            nSSize.height = 3.4028234663852886E38;
            nSSize.width = 3.4028234663852886E38;
            nSTextView.setMaxSize(nSSize);
            nSTextView.setAutoresizingMask(18L);
            if ((this.style & 0x40) == 0) {
                NSTextContainer nSTextContainer = nSTextView.textContainer();
                nSTextView.setHorizontallyResizable(true);
                nSTextContainer.setWidthTracksTextView(false);
                NSSize nSSize2 = new NSSize();
                nSSize2.height = 3.4028234663852886E38;
                nSSize2.width = 3.4028234663852886E38;
                nSTextContainer.setContainerSize(nSSize2);
            }
            int n = 0;
            if ((this.style & 0x1000000) != 0) {
                n = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n = 1;
            }
            nSTextView.setAlignment(n);
            nSTextView.setRichText(false);
            nSTextView.setDelegate(nSTextView);
            nSTextView.setFont(this.display.getSystemFont().handle);
            nSTextView.setUsesFontPanel(false);
            this.view = nSTextView;
            this.scrollView = nSScrollView;
        }
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x400000) != 0) {
            NSText nSText = this.view.window().fieldEditor(true, this.view);
            long l = OS.objc_lookUpClass("NSSecureTextView");
            if (nSText != null && l != 0L && nSText.isKindOfClass(l)) {
                long l2 = OS.objc_getClass("SWTSecureEditorView");
                OS.object_setClass(nSText.id, l2);
            }
        }
        this.doubleClick = true;
        this.message = "";
    }

    public void cut() {
        Object object;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        if ((this.style & 0x400000) != 0 || this.echoCharacter != '\u0000') {
            return;
        }
        boolean bl = true;
        char[] cArray = null;
        Point point = this.getSelection();
        if ((this.hooks(25) || this.filters(25)) && point.x != point.y) {
            cArray = this.getEditText(point.x, point.y - 1);
            object = this.verifyText("", point.x, point.y, null);
            if (object == null) {
                return;
            }
            if (((String)object).length() != 0) {
                this.copyToClipboard(cArray);
                if ((this.style & 4) != 0) {
                    this.insertEditText((String)object);
                } else {
                    NSTextView nSTextView = (NSTextView)this.view;
                    nSTextView.replaceCharactersInRange(nSTextView.selectedRange(), NSString.stringWith((String)object));
                }
                bl = false;
            }
        }
        if (bl) {
            if ((this.style & 4) != 0) {
                if (cArray == null) {
                    cArray = this.getEditText(point.x, point.y - 1);
                }
                this.copyToClipboard(cArray);
                this.insertEditText("");
            } else {
                ((NSTextView)this.view).cut(null);
            }
        }
        object = this.getSelection();
        if (!bl || !point.equals(object)) {
            this.sendEvent(24);
        }
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        if ((this.style & 2) != 0) {
            return this.display.textViewFont;
        }
        if ((this.style & 0x80) != 0) {
            return this.display.searchFieldFont;
        }
        if ((this.style & 0x400000) != 0) {
            return this.display.secureTextFieldFont;
        }
        return this.display.textFieldFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        if ((this.style & 4) != 0) {
            this.display.removeWidget(((NSControl)this.view).cell());
        }
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if ((this.style & 4) != 0) {
            NSText nSText;
            if (this.backgroundImage == null) {
                return;
            }
            if (new NSView(l).isKindOfClass(OS.class_NSText) && !(nSText = new NSText(l)).isFieldEditor()) {
                return;
            }
        }
        if ((this.style & 2) != 0 && l != this.scrollView.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        Image image;
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
            control.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        }
        super.drawInteriorWithFrame_inView(l, l2, nSRect, l3);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        long l;
        Point point = this.getSelection();
        if (point.x != point.y && (long)point.x <= (l = this.getPosition(n, n2)) && l < (long)point.y && super.dragDetect(n, n2, bl, blArray)) {
            if (blArray != null) {
                blArray[0] = true;
            }
            return true;
        }
        return false;
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if ((this.style & 2) != 0) {
            this.setForeground(this.foreground);
        }
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        return cursor != null ? cursor : this.display.getSystemCursor(19);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (this.getTopPixel() + this.getCaretLocation().y) / this.getLineHeight();
    }

    boolean acceptsFirstResponder(long l, long l2) {
        if ((this.style & 8) != 0) {
            return true;
        }
        return super.acceptsFirstResponder(l, l2);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        NSTextView nSTextView = null;
        if ((this.style & 4) != 0) {
            if (this.hasFocus()) {
                nSTextView = new NSTextView(this.view.window().fieldEditor(true, this.view));
            }
        } else {
            nSTextView = (NSTextView)this.view;
        }
        if (nSTextView == null) {
            return new Point(0, 0);
        }
        NSLayoutManager nSLayoutManager = nSTextView.layoutManager();
        NSTextContainer nSTextContainer = nSTextView.textContainer();
        NSRange nSRange = nSTextView.selectedRange();
        long[] lArray = new long[1];
        long l = nSLayoutManager.rectArrayForCharacterRange(nSRange, nSRange, nSTextContainer, lArray);
        NSRect nSRect = new NSRect();
        if (lArray[0] > 0L) {
            OS.memmove(nSRect, l, (long)NSRect.sizeof);
        }
        return new Point((int)nSRect.x, (int)nSRect.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.selectionRange != null ? (int)this.selectionRange.location : 0;
        }
        NSRange nSRange = ((NSTextView)this.view).selectedRange();
        return (int)nSRange.location;
    }

    public int getCharCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return (int)((NSControl)this.view).stringValue().length();
        }
        return (int)((NSTextView)this.view).textStorage().length();
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    char[] getEditText() {
        if (this.hiddenText != null) {
            char[] cArray = new char[this.hiddenText.length];
            System.arraycopy(this.hiddenText, 0, cArray, 0, cArray.length);
            return cArray;
        }
        NSString nSString = null;
        nSString = (this.style & 4) != 0 ? ((NSTextField)this.view).stringValue() : ((NSTextView)this.view).textStorage().string();
        int n = (int)nSString.length();
        char[] cArray = new char[n];
        NSRange nSRange = new NSRange();
        nSRange.length = n;
        nSString.getCharacters(cArray, nSRange);
        return cArray;
    }

    char[] getEditText(int n, int n2) {
        NSString nSString = null;
        nSString = (this.style & 4) != 0 ? ((NSTextField)this.view).stringValue() : ((NSTextView)this.view).textStorage().string();
        int n3 = (int)nSString.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return new char[0];
        }
        n = Math.max(0, n);
        NSRange nSRange = new NSRange();
        nSRange.location = n;
        nSRange.length = Math.max(0, n2 - n + 1);
        char[] cArray = new char[(int)nSRange.length];
        if (this.hiddenText != null) {
            System.arraycopy(this.hiddenText, (int)nSRange.location, cArray, 0, cArray.length);
        } else {
            nSString.getCharacters(cArray, nSRange);
        }
        return cArray;
    }

    NSString getInsertString(String string, NSRange nSRange) {
        int n;
        int n2 = this.getCharCount();
        int n3 = string.length();
        int n4 = n = nSRange != null ? (int)nSRange.length : 0;
        if (n2 - n + n3 > this.textLimit) {
            n3 = this.textLimit - n2 + n;
            n3 = Math.max(0, n3);
        }
        char[] cArray = new char[n3];
        string.getChars(0, cArray.length, cArray, 0);
        NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
        return nSString;
    }

    public int getLineCount() {
        long l;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        NSTextStorage nSTextStorage = ((NSTextView)this.view).textStorage();
        int n = (int)nSTextStorage.paragraphs().count();
        NSString nSString = nSTextStorage.string();
        long l2 = nSString.length();
        if (l2 == 0L || (l = nSString.characterAtIndex(l2 - 1L)) == 10L || l == 13L) {
            ++n;
        }
        return n;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        Font font;
        this.checkWidget();
        Font font2 = font = this.font != null ? this.font : this.defaultFont();
        if ((this.style & 4) != 0) {
            NSDictionary nSDictionary = NSDictionary.dictionaryWithObject(font.handle, OS.NSFontAttributeName);
            NSString nSString = NSString.stringWith(" ");
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, nSDictionary);
            NSSize nSSize = nSAttributedString.size();
            nSAttributedString.release();
            return (int)nSSize.height;
        }
        NSTextView nSTextView = (NSTextView)this.view;
        return (int)Math.ceil(nSTextView.layoutManager().defaultLineHeightForFont(font.handle));
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    long getPosition(long l, long l2) {
        if ((this.style & 2) != 0) {
            NSTextView nSTextView = (NSTextView)this.view;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = l;
            nSPoint.y = l2;
            return nSTextView.characterIndexForInsertionAtPoint(nSPoint);
        }
        return 0L;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (this.selectionRange == null) {
                NSString nSString = ((NSTextField)this.view).stringValue();
                return new Point((int)nSString.length(), (int)nSString.length());
            }
            return new Point((int)this.selectionRange.location, (int)(this.selectionRange.location + this.selectionRange.length));
        }
        NSTextView nSTextView = (NSTextView)this.view;
        NSRange nSRange = nSTextView.selectedRange();
        return new Point((int)nSRange.location, (int)(nSRange.location + nSRange.length));
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.selectionRange != null ? (int)this.selectionRange.length : 0;
        }
        NSTextView nSTextView = (NSTextView)this.view;
        NSRange nSRange = nSTextView.selectedRange();
        return (int)nSRange.length;
    }

    public String getSelectionText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            Point point = this.getSelection();
            if (point.x == point.y) {
                return "";
            }
            return new String(this.getEditText(point.x, point.y - 1));
        }
        NSTextView nSTextView = (NSTextView)this.view;
        NSRange nSRange = nSTextView.selectedRange();
        NSString nSString = nSTextView.textStorage().string();
        char[] cArray = new char[(int)nSRange.length];
        nSString.getCharacters(cArray, nSRange);
        return new String(cArray);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return new String(this.getEditText());
        }
        NSString nSString = ((NSTextView)this.view).textStorage().string();
        return nSString.getString();
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        if ((this.style & 4) != 0) {
            return new String(this.getEditText(n, n2));
        }
        NSTextStorage nSTextStorage = ((NSTextView)this.view).textStorage();
        if (n > (n2 = Math.min(n2, (int)nSTextStorage.length() - 1))) {
            return "";
        }
        n = Math.max(0, n);
        NSRange nSRange = new NSRange();
        nSRange.location = n;
        nSRange.length = n2 - n + 1;
        NSAttributedString nSAttributedString = nSTextStorage.attributedSubstringFromRange(nSRange);
        NSString nSString = nSAttributedString.string();
        return nSString.getString();
    }

    public char[] getTextChars() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.getEditText();
        }
        NSString nSString = ((NSTextView)this.view).textStorage().string();
        int n = (int)nSString.length();
        char[] cArray = new char[n];
        NSRange nSRange = new NSRange();
        nSRange.length = n;
        nSString.getCharacters(cArray, nSRange);
        return cArray;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopPixel() / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (int)this.scrollView.contentView().bounds().y;
    }

    public void insert(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            object = this.getSelection();
            if ((string = this.verifyText(string, ((Point)object).x, ((Point)object).y, null)) == null) {
                return;
            }
        }
        if ((this.style & 4) != 0) {
            this.insertEditText(string);
        } else {
            object = (NSTextView)this.view;
            NSRange nSRange = ((NSText)object).selectedRange();
            NSString nSString = this.textLimit != LIMIT ? this.getInsertString(string, nSRange) : NSString.stringWith(string);
            ((NSTextView)object).textStorage().replaceCharactersInRange(nSRange, nSString);
        }
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    void insertEditText(String string) {
        int n = string.length();
        Point point = this.getSelection();
        if (this.hasFocus() && this.hiddenText == null) {
            int n2;
            if (this.textLimit != LIMIT && (n2 = this.getCharCount()) - (point.y - point.x) + n > this.textLimit) {
                n = this.textLimit - n2 + (point.y - point.x);
                n = Math.max(0, n);
            }
            char[] cArray = new char[n];
            string.getChars(0, cArray.length, cArray, 0);
            NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
            NSText nSText = ((NSTextField)this.view).currentEditor();
            if (nSText != null) {
                nSText.replaceCharactersInRange(nSText.selectedRange(), nSString);
            }
            this.selectionRange = null;
        } else {
            int n3;
            String string2 = this.getText();
            if (this.textLimit != LIMIT && (n3 = string2.length()) - (point.y - point.x) + n > this.textLimit) {
                string = string.substring(0, this.textLimit - n3 + (point.y - point.x));
            }
            String string3 = string2.substring(0, point.x) + string + string2.substring(point.y);
            this.setEditText(string3);
            this.setSelection(point.x + string.length());
        }
    }

    boolean isEventView(long l) {
        if ((this.style & 2) != 0) {
            return super.isEventView(l);
        }
        return true;
    }

    boolean isNeeded(ScrollBar scrollBar) {
        boolean bl = false;
        if ((this.style & 2) != 0) {
            NSRect nSRect = this.scrollView.documentView().frame();
            NSRect nSRect2 = this.scrollView.contentView().frame();
            bl = (scrollBar.style & 0x200) != 0 ? nSRect.height > nSRect2.height : nSRect.width > nSRect2.width;
        }
        return bl;
    }

    public void paste() {
        NSObject nSObject;
        Object object;
        Object object2;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean bl = true;
        String string = null;
        if ((this.hooks(25) || this.filters(25)) && (string = this.getClipboardText()) != null) {
            object2 = this.getSelection();
            object = this.verifyText(string, ((Point)object2).x, ((Point)object2).y, null);
            if (object == null) {
                return;
            }
            if (!((String)object).equals(string)) {
                if ((this.style & 4) != 0) {
                    this.insertEditText((String)object);
                } else {
                    nSObject = (NSTextView)this.view;
                    NSRange nSRange = ((NSText)nSObject).selectedRange();
                    NSString nSString = this.textLimit != LIMIT ? this.getInsertString((String)object, nSRange) : NSString.stringWith((String)object);
                    ((NSText)nSObject).replaceCharactersInRange(nSRange, nSString);
                }
                bl = false;
            }
        }
        if (bl) {
            if ((this.style & 4) != 0) {
                if (string == null) {
                    string = this.getClipboardText();
                }
                if (string == null) {
                    return;
                }
                this.insertEditText(string);
            } else if (this.textLimit != LIMIT) {
                if (string == null) {
                    string = this.getClipboardText();
                }
                if (string == null) {
                    return;
                }
                object2 = (NSTextView)this.view;
                object = ((NSText)object2).selectedRange();
                nSObject = this.getInsertString(string, (NSRange)object);
                ((NSText)object2).replaceCharactersInRange((NSRange)object, (NSString)nSObject);
            } else {
                ((NSTextView)this.view).paste(null);
            }
        }
        this.sendEvent(24);
    }

    void register() {
        super.register();
        if ((this.style & 4) != 0) {
            this.display.addWidget(((NSControl)this.view).cell(), this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if ((this.style & 4) != 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.hiddenText = null;
        this.message = null;
        this.selectionRange = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            this.setSelection(0, this.getCharCount());
        } else {
            ((NSTextView)this.view).selectAll(null);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        short s;
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        long l = nSEvent.modifierFlags();
        if ((l & 0x100000L) != 0L) {
            s = nSEvent.keyCode();
            switch (s) {
                case 7: {
                    if ((this.style & 0x400000) == 0) {
                        this.cut();
                    }
                    return false;
                }
                case 8: {
                    if ((this.style & 0x400000) == 0) {
                        this.copy();
                    }
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    NSApplication.sharedApplication().sendAction(OS.sel_selectAll_, null, NSApplication.sharedApplication());
                    return false;
                }
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        if ((this.style & 4) != 0) {
            s = nSEvent.keyCode();
            switch (s) {
                case 36: 
                case 76: {
                    this.sendSelectionEvent(14);
                }
            }
        }
        return bl;
    }

    boolean sendKeyEvent(int n, Event event) {
        boolean bl = super.sendKeyEvent(n, event);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        if ((event.stateMask & 0x400000) != 0) {
            switch (event.keyCode) {
                case 122: {
                    NSUndoManager nSUndoManager = this.view.undoManager();
                    if (nSUndoManager == null && (this.style & 4) != 0) {
                        NSText nSText = ((NSTextField)this.view).currentEditor();
                        nSUndoManager = nSText.undoManager();
                    }
                    if (nSUndoManager != null) {
                        if ((event.stateMask & 0x20000) != 0) {
                            if (nSUndoManager.canRedo()) {
                                nSUndoManager.redo();
                                return false;
                            }
                        } else if (nSUndoManager.canUndo()) {
                            nSUndoManager.undo();
                            return false;
                        }
                    }
                    return false;
                }
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        return bl;
    }

    void sendSearchSelection() {
        if (this.targetSearch != null) {
            ((NSSearchField)this.view).sendAction(this.actionSearch, this.targetSearch);
        }
        Event event = new Event();
        event.detail = 512;
        this.sendSelectionEvent(14, event, false);
    }

    void sendCancelSelection() {
        if (this.targetCancel != null) {
            ((NSSearchField)this.view).sendAction(this.actionCancel, this.targetCancel);
        }
        Event event = new Event();
        event.detail = 256;
        this.sendSelectionEvent(14, event, false);
    }

    void setBackgroundColor(NSColor nSColor) {
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setBackgroundColor(nSColor);
        } else {
            ((NSTextView)this.view).setBackgroundColor(nSColor);
        }
    }

    void setBackgroundImage(NSImage nSImage) {
        if ((this.style & 4) != 0) {
            NSTextField nSTextField = (NSTextField)this.view;
            nSTextField.setDrawsBackground(nSImage == null);
        } else {
            ((NSTextView)this.view).setDrawsBackground(nSImage == null);
            this.scrollView.setDrawsBackground(nSImage == null);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x400000) == 0) {
            Point point = this.getSelection();
            char[] cArray = this.getTextChars();
            this.echoCharacter = c;
            this.setEditText(cArray);
            this.setSelection(point);
        }
        this.echoCharacter = c;
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style = bl ? (this.style &= 0xFFFFFFF7) : (this.style |= 8);
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setEditable(bl);
        } else {
            ((NSTextView)this.view).setEditable(bl);
        }
    }

    void setEditText(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        this.setEditText(cArray);
    }

    void setEditText(char[] cArray) {
        char[] cArray2;
        int n = Math.min(cArray.length, this.textLimit);
        if ((this.style & 0x400000) == 0 && this.echoCharacter != '\u0000') {
            this.hiddenText = new char[n];
            cArray2 = new char[n];
            for (int i = 0; i < n; ++i) {
                this.hiddenText[i] = cArray[i];
                cArray2[i] = this.echoCharacter;
            }
        } else {
            this.hiddenText = null;
            cArray2 = cArray;
        }
        NSTextField nSTextField = (NSTextField)this.view;
        NSString nSString = NSString.stringWithCharacters(cArray2, n);
        nSTextField.setStringValue(nSString);
        NSText nSText = nSTextField.currentEditor();
        if (nSText != null) {
            nSText.setString(nSString);
        }
        this.selectionRange = null;
    }

    void setFrameSize(long l, long l2, NSSize nSSize) {
        NSArray nSArray;
        NSSearchField nSSearchField;
        NSText nSText;
        super.setFrameSize(l, l2, nSSize);
        if ((this.style & 0x80) != 0 && (nSText = (nSSearchField = (NSSearchField)this.view).currentEditor()) != null && (nSArray = nSSearchField.subviews()).count() > 0L) {
            NSRect nSRect = nSSearchField.cell().drawingRectForBounds(nSSearchField.bounds());
            new NSView(nSArray.objectAtIndex(0L)).setFrame(nSRect);
        }
    }

    void setFont(NSFont nSFont) {
        if ((this.style & 2) != 0) {
            ((NSTextView)this.view).setFont(nSFont);
            return;
        }
        super.setFont(nSFont);
    }

    void setForeground(double[] dArray) {
        NSColor nSColor;
        if (dArray == null) {
            nSColor = NSColor.textColor();
            if ((this.style & 2) != 0 && !this.isEnabled()) {
                nSColor = NSColor.disabledControlTextColor();
            }
        } else {
            double d = 1.0;
            if ((this.style & 2) != 0 && !this.isEnabled()) {
                d = 0.5;
            }
            nSColor = NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], d);
        }
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setTextColor(nSColor);
        } else {
            ((NSTextView)this.view).setTextColor(nSColor);
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    void setOrientation() {
        int n;
        int n2 = n = (this.style & 0x4000000) != 0 ? 1 : 0;
        if ((this.style & 4) != 0) {
            NSTextField nSTextField = (NSTextField)this.view;
            nSTextField.setBaseWritingDirection(n);
        } else {
            NSTextView nSTextView = (NSTextView)this.view;
            nSTextView.setBaseWritingDirection(n);
        }
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 4) != 0) {
            NSString nSString = NSString.stringWith(string);
            NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(((NSTextField)this.view).cell());
            nSTextFieldCell.setPlaceholderString(nSString);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.setSelection(n, n);
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            NSString nSString = ((NSTextField)this.view).stringValue();
            int n3 = (int)nSString.length();
            int n4 = Math.min(Math.max(Math.min(n, n2), 0), n3);
            int n5 = Math.min(Math.max(Math.max(n, n2), 0), n3);
            this.selectionRange = new NSRange();
            this.selectionRange.location = n4;
            this.selectionRange.length = n5 - n4;
            NSText nSText = ((NSControl)this.view).currentEditor();
            if (nSText != null) {
                nSText.setSelectedRange(this.selectionRange);
                nSText.scrollRangeToVisible(this.selectionRange);
            }
        } else {
            int n6 = (int)((NSTextView)this.view).textStorage().length();
            int n7 = Math.min(Math.max(Math.min(n, n2), 0), n6);
            int n8 = Math.min(Math.max(Math.max(n, n2), 0), n6);
            NSRange nSRange = new NSRange();
            nSRange.location = n7;
            nSRange.length = n8 - n7;
            NSTextView nSTextView = (NSTextView)this.view;
            nSTextView.setSelectedRange(nSRange);
            nSTextView.scrollRangeToVisible(nSRange);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
        if (this.tabs == n) {
            return;
        }
        this.tabs = n;
        if ((this.style & 4) != 0) {
            return;
        }
        double d = this.textExtent((String)"s").width * (double)n;
        NSTextView nSTextView = (NSTextView)this.view;
        NSParagraphStyle nSParagraphStyle = nSTextView.defaultParagraphStyle();
        NSMutableParagraphStyle nSMutableParagraphStyle = new NSMutableParagraphStyle(nSParagraphStyle.mutableCopy());
        nSMutableParagraphStyle.setTabStops(NSArray.array());
        NSTextTab nSTextTab = (NSTextTab)new NSTextTab().alloc();
        nSTextTab = nSTextTab.initWithType(0L, d);
        nSMutableParagraphStyle.addTabStop(nSTextTab);
        nSTextTab.release();
        nSMutableParagraphStyle.setDefaultTabInterval(d);
        nSTextView.setDefaultParagraphStyle(nSMutableParagraphStyle);
        nSMutableParagraphStyle.release();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 4) != 0) {
            this.setEditText(string);
            NSText nSText = ((NSControl)this.view).currentEditor();
            if (nSText != null) {
                NSRange nSRange = new NSRange();
                nSText.setSelectedRange(nSRange);
                nSText.scrollRangeToVisible(nSRange);
            }
        } else {
            NSTextView nSTextView = (NSTextView)this.view;
            char[] cArray = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, cArray.length, cArray, 0);
            NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
            nSTextView.setString(nSString);
            nSTextView.setSelectedRange(new NSRange());
        }
        this.sendEvent(24);
    }

    public void setTextChars(char[] cArray) {
        Object object;
        this.checkWidget();
        if (cArray == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            object = this.verifyText(new String(cArray), 0, this.getCharCount(), null);
            if (object == null) {
                return;
            }
            cArray = new char[((String)object).length()];
            ((String)object).getChars(0, cArray.length, cArray, 0);
        }
        if ((this.style & 4) != 0) {
            this.setEditText(cArray);
            object = ((NSControl)this.view).currentEditor();
            if (object != null) {
                NSRange nSRange = new NSRange();
                ((NSText)object).setSelectedRange(nSRange);
                ((NSText)object).scrollRangeToVisible(nSRange);
            }
        } else {
            object = (NSTextView)this.view;
            int n = Math.min(cArray.length, this.textLimit);
            NSString nSString = NSString.stringWithCharacters(cArray, n);
            ((NSText)object).setString(nSString);
            ((NSText)object).setSelectedRange(new NSRange());
        }
        this.sendEvent(24);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (n < 0) {
            return;
        }
        this.textLimit = n;
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int n2 = Math.max(0, Math.min(n, this.getLineCount() - 1));
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = this.getLineHeight() * n2;
        this.view.scrollPoint(nSPoint);
    }

    boolean shouldChangeTextInRange_replacementString(long l, long l2, long l3, long l4) {
        NSObject nSObject;
        String string;
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l3, (long)NSRange.sizeof);
        boolean bl = this.callSuperBoolean(l, l2, nSRange, l4);
        NSString nSString = new NSString(l4);
        if (!(this.hooks(25) || this.echoCharacter != '\u0000' && (this.style & 0x400000) == 0)) {
            return bl && (long)this.getCharCount() - nSRange.length + nSString.length() <= (long)this.textLimit;
        }
        String string2 = string = nSString.getString();
        if (this.hooks(25)) {
            nSObject = this.display.application.currentEvent();
            long l5 = ((NSEvent)nSObject).type();
            if (l5 != 10L && l5 != 11L) {
                nSObject = null;
            }
            string2 = this.verifyText(string, (int)nSRange.location, (int)(nSRange.location + nSRange.length), (NSEvent)nSObject);
        }
        if (string2 == null) {
            return false;
        }
        if ((long)this.getCharCount() - nSRange.length + (long)string2.length() > (long)this.textLimit) {
            return false;
        }
        if ((this.style & 4) != 0) {
            if (string != string2 || this.echoCharacter != '\u0000') {
                if (nSRange.length == 1L) {
                    nSObject = new NSText(l);
                    ((NSText)nSObject).setSelectedRange(nSRange);
                }
                this.insertEditText(string2);
                bl = false;
            }
        } else if (string != string2) {
            nSObject = (NSTextView)this.view;
            ((NSTextView)nSObject).textStorage().replaceCharactersInRange(((NSText)nSObject).selectedRange(), NSString.stringWith(string2));
            bl = false;
        }
        if (!bl) {
            this.sendEvent(24);
        }
        return bl;
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            this.setSelection(this.getSelection());
        } else {
            NSTextView nSTextView = (NSTextView)this.view;
            nSTextView.scrollRangeToVisible(nSTextView.selectedRange());
        }
    }

    void textViewDidChangeSelection(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSText nSText = new NSText(nSNotification.object().id);
        this.selectionRange = nSText.selectedRange();
    }

    void textDidChange(long l, long l2, long l3) {
        if ((this.style & 4) != 0) {
            super.textDidChange(l, l2, l3);
        }
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long l, long l2, long l3, long l4, long l5) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l5, (long)NSRange.sizeof);
        return nSRange;
    }

    int traversalCode(int n, NSEvent nSEvent) {
        int n2 = super.traversalCode(n, nSEvent);
        if ((this.style & 8) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            n2 &= 0xFFFFFFFB;
            if (n == 48 && nSEvent != null) {
                boolean bl;
                long l = nSEvent.modifierFlags();
                boolean bl2 = bl = (l & 0x20000L) == 0L;
                if (bl && (l & 0x40000L) == 0L) {
                    n2 &= 0xFFFFFFE7;
                }
            }
        }
        return n2;
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.scrollView == null) {
            return;
        }
        NSClipView nSClipView = this.scrollView.contentView();
        nSClipView.setDocumentCursor(bl ? NSCursor.IBeamCursor() : null);
    }

    String verifyText(String string, int n, int n2, NSEvent nSEvent) {
        Event event = new Event();
        if (nSEvent != null) {
            this.setKeyState(event, 3, nSEvent);
        }
        event.text = string;
        event.start = n;
        event.end = n2;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

