/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.modalDialog";
    static /* synthetic */ Class class$0;

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    static int checkStyle(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0 && ((n &= 0xEFFFFFFF) & n2) == 0) {
            n |= shell == null ? 65536 : 32768;
        }
        return n;
    }

    public void setPrinterData(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public PrinterData open() {
        int[] nArray = new int[1];
        if (OS.PMCreateSession(nArray) == 0) {
            int n = nArray[0];
            if (OS.PMCreatePrintSettings(nArray) == 0) {
                int n2 = nArray[0];
                OS.PMSessionDefaultPrintSettings(n, n2);
                if (OS.PMCreatePageFormat(nArray) == 0) {
                    int n3 = nArray[0];
                    OS.PMSessionDefaultPageFormat(n, n3);
                    OS.PMSessionSetDestination(n, n2, (short)(this.printerData.printToFile ? 2 : 1), 0, 0);
                    if (this.printerData.scope == 1) {
                        OS.PMSetFirstPage(n2, this.printerData.startPage, false);
                        OS.PMSetLastPage(n2, this.printerData.endPage, false);
                        OS.PMSetPageRange(n2, this.printerData.startPage, this.printerData.endPage);
                    } else {
                        OS.PMSetPageRange(n2, 1, Integer.MAX_VALUE);
                    }
                    OS.PMSetCopies(n2, this.printerData.copyCount, false);
                    OS.PMSetCollate(n2, this.printerData.collate);
                    OS.PMSetOrientation(n3, this.printerData.orientation == 2 ? (short)2 : 1, false);
                    boolean[] blArray = new boolean[1];
                    Shell shell = this.getParent();
                    Display display = shell != null ? shell.getDisplay() : Display.getCurrent();
                    display.setData(SET_MODAL_DIALOG, this);
                    if (OS.VERSION >= 4176) {
                        int n4 = 33024;
                        OS.PMShowPrintDialogWithOptions(n, n2, n3, n4, blArray);
                    } else {
                        OS.PMSessionPageSetupDialog(n, n3, blArray);
                        if (blArray[0]) {
                            OS.PMSessionPrintDialog(n, n2, n3, blArray);
                        }
                    }
                    display.setData(SET_MODAL_DIALOG, null);
                    if (blArray[0]) {
                        short[] sArray = new short[1];
                        OS.PMSessionGetDestinationType(n, n2, sArray);
                        String string = Printer.getCurrentPrinterName(n);
                        String string2 = "Mac";
                        switch (sArray[0]) {
                            case 3: {
                                string2 = "Fax";
                                break;
                            }
                            case 2: {
                                string2 = "File";
                                break;
                            }
                            case 4: {
                                string2 = "Preview";
                                break;
                            }
                            case 1: {
                                string2 = "Printer";
                            }
                        }
                        PrinterData printerData = new PrinterData(string2, string);
                        if (sArray[0] == 2) {
                            printerData.printToFile = true;
                            OS.PMSessionCopyDestinationLocation(n, n2, nArray);
                            int n5 = OS.CFURLCopyFileSystemPath(nArray[0], 0);
                            OS.CFRelease(nArray[0]);
                            printerData.fileName = Printer.getString(n5);
                            OS.CFRelease(n5);
                        }
                        OS.PMGetCopies(n2, nArray);
                        printerData.copyCount = nArray[0];
                        OS.PMGetFirstPage(n2, nArray);
                        printerData.startPage = nArray[0];
                        OS.PMGetLastPage(n2, nArray);
                        printerData.endPage = nArray[0];
                        printerData.scope = printerData.startPage == 1 && printerData.endPage == Integer.MAX_VALUE ? 0 : 1;
                        boolean[] blArray2 = new boolean[1];
                        OS.PMGetCollate(n2, blArray2);
                        printerData.collate = blArray2[0];
                        short[] sArray2 = new short[1];
                        OS.PMGetOrientation(n3, sArray2);
                        printerData.orientation = sArray2[0] == 2 ? 2 : 1;
                        int[] nArray2 = new int[1];
                        OS.PMFlattenPrintSettings(n2, nArray2);
                        int[] nArray3 = new int[1];
                        OS.PMFlattenPageFormat(n3, nArray3);
                        int n6 = OS.GetHandleSize(nArray2[0]);
                        int n7 = OS.GetHandleSize(nArray3[0]);
                        printerData.otherData = new byte[n6 + n7 + 8];
                        byte[] byArray = printerData.otherData;
                        int n8 = 0;
                        n8 = Printer.packData(nArray2[0], byArray, n8);
                        n8 = Printer.packData(nArray3[0], byArray, n8);
                        OS.DisposeHandle(nArray2[0]);
                        OS.DisposeHandle(nArray3[0]);
                        this.printerData = printerData;
                        return printerData;
                    }
                    OS.PMRelease(n3);
                }
                OS.PMRelease(n2);
            }
            OS.PMRelease(n);
        }
        return null;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            SWT.error(43);
        }
    }
}

