/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlEditTextSelectionRec;
import org.eclipse.swt.internal.carbon.MenuTrackingData;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int menuHandle;
    int textLimit = LIMIT;
    String lastText = "";
    ControlEditTextSelectionRec selection;
    static final int VISIBLE_COUNT = 10;
    public static final int LIMIT = Integer.MAX_VALUE;
    static final String[] AX_ATTRIBUTES = new String[]{"AXValue", "AXNumberOfCharacters", "AXSelectedText", "AXSelectedTextRange", "AXStringForRange"};

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n2 == 0) {
            this.error(14);
        }
        if ((this.style & 8) != 0) {
            n = OS.AppendMenuItemTextWithCFString(this.menuHandle, n2, 0, 0, null);
            if (string.startsWith("-")) {
                OS.ChangeMenuItemAttributes(this.menuHandle, OS.CountMenuItems(this.menuHandle), 0, 64);
            }
        } else {
            n = OS.HIComboBoxAppendTextItem(this.handle, n2, null);
        }
        OS.CFRelease(n2);
        if (n != 0) {
            this.error(14);
        }
    }

    public void add(String string, int n) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getItemCount();
        if (n < 0 || n > n3) {
            this.error(6);
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n4 == 0) {
            this.error(14);
        }
        int n5 = -1;
        if ((this.style & 8) != 0) {
            n5 = OS.GetControlValue(this.handle) - 1;
            n2 = OS.InsertMenuItemTextWithCFString(this.menuHandle, n4, (short)n, 0, 0);
            if (string.startsWith("-")) {
                OS.ChangeMenuItemAttributes(this.menuHandle, (short)(n + 1), 0, 64);
            }
        } else {
            n2 = OS.HIComboBoxInsertTextItemAtIndex(this.handle, n, n4);
        }
        OS.CFRelease(n4);
        if (n2 != 0) {
            this.error(14);
        }
        if (n5 >= n) {
            OS.SetControl32BitValue(this.handle, n5 + 2);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    int callFocusEventHandler(int n, int n2) {
        short[] sArray = new short[1];
        if ((this.style & 8) == 0) {
            OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
            if (sArray[0] == 0) {
                this.selection = new ControlEditTextSelectionRec();
                OS.GetControlData(this.handle, (short)0, 1936026725, 4, this.selection, null);
            }
        }
        int n3 = super.callFocusEventHandler(n, n2);
        if ((this.style & 8) == 0 && sArray[0] != 0 && this.selection != null) {
            OS.SetControlData(this.handle, 0, 1936026725, 4, this.selection);
            this.selection = null;
        }
        return n3;
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    void checkSelection() {
        if ((this.style & 8) != 0) {
            return;
        }
        String string = this.getText();
        if (string.equals(this.lastText)) {
            return;
        }
        if (this.hooks(25) || this.filters(25)) {
            this.setText(this.lastText, false);
            string = this.verifyText(string, 0, this.lastText.length(), null);
            if (string == null) {
                return;
            }
            this.setText(string, false);
        } else {
            this.lastText = string;
        }
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        int n = this.indexOf(string);
        if (n != -1) {
            this.sendSelectionEvent(13);
        }
        String string2 = "AXFocusedWindowChanged";
        char[] cArray = new char[string2.length()];
        string2.getChars(0, cArray.length, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        OS.AXNotificationHIObjectNotify(n2, this.handle, 0L);
        OS.CFRelease(n2);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point point = this.getSelection();
            point.y = point.x;
            this.setSelection(point);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[1];
        if ((this.style & 8) != 0) {
            int n5 = OS.GetControlValue(this.handle) - 1;
            OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(n5 + 1), nArray);
        } else {
            OS.GetControlData(this.handle, (short)5, 1667658612, 4, nArray, null);
        }
        Point point = this.textExtent(nArray[0], 0);
        if (nArray[0] != 0) {
            OS.CFRelease(nArray[0]);
        }
        n3 = Math.max(n3, point.x);
        n4 = Math.max(n4, point.y);
        int n6 = (this.style & 8) != 0 ? OS.CountMenuItems(this.menuHandle) : OS.HIComboBoxGetItemCount(this.handle);
        int n7 = 0;
        while (n7 < n6) {
            int n8 = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(n7 + 1), nArray) : OS.HIComboBoxCopyTextItemAtIndex(this.handle, n7, nArray);
            if (n8 == 0) {
                point = this.textExtent(nArray[0], 0);
                n3 = Math.max(n3, point.x);
                OS.CFRelease(nArray[0]);
            }
            ++n7;
        }
        int[] nArray2 = new int[1];
        if ((this.style & 8) != 0) {
            OS.GetThemeMetric(22, nArray2);
            n3 += nArray2[0];
            n3 += 13;
        } else {
            OS.GetThemeMetric(74, nArray2);
            n3 += nArray2[0];
        }
        OS.GetThemeMetric(4, nArray2);
        n3 += nArray2[0] * 2;
        n4 += nArray2[0] * 2;
        Rect rect = this.getInset();
        n3 += rect.left + rect.right;
        n4 += rect.top + rect.bottom;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    public void copy() {
        this.checkWidget();
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        this.copyToClipboard(this.getText(point.x, point.y));
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            int[] nArray = new int[1];
            int n = OS.GetControlOwner(this.parent.handle);
            OS.CreatePopupButtonControl(n, null, 0, (short)-12345, false, (short)0, (short)0, 0, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            int[] nArray2 = new int[1];
            OS.CreateNewMenu((short)0, 0, nArray2);
            if (nArray2[0] == 0) {
                this.error(2);
            }
            this.menuHandle = nArray2[0];
            OS.SetControlPopupMenuHandle(this.handle, this.menuHandle);
            OS.SetControl32BitMaximum(this.handle, Short.MAX_VALUE);
        } else {
            int[] nArray = new int[1];
            CGRect cGRect = new CGRect();
            int n = 8;
            OS.HIComboBoxCreate(cGRect, 0, null, 0, n, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            OS.SetControlData(this.handle, 5, 1684238964, 4, new byte[1]);
            OS.SetControlData(this.handle, 0, 1667395177, 4, new int[]{10});
            OS.HIViewSetVisible(this.handle, true);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        int n = point.x;
        int n2 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2, string.length());
        String string4 = string.substring(n, n2);
        String string5 = "";
        if ((this.hooks(25) || this.filters(25)) && (string5 = this.verifyText(string5, n, n2, null)) == null) {
            return;
        }
        char[] cArray = new char[string4.length()];
        string4.getChars(0, cArray.length, cArray, 0);
        this.copyToClipboard(cArray);
        this.setText(String.valueOf(string2) + string5 + string3, false);
        this.setSelection(new Point(n += string5.length(), n));
        this.sendEvent(24);
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        if (n == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                OS.SetControl32BitValue(this.handle, 0);
                this.sendEvent(24);
            } else {
                this.setText("");
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            OS.SetControl32BitValue(this.handle, 0);
            this.sendEvent(24);
        } else {
            this.setText("");
        }
    }

    void destroyWidget() {
        if ((this.getShell().state & 0x10000) != 0) {
            super.destroyWidget();
        } else {
            this.releaseHandle();
        }
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    public String getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        int[] nArray = new int[1];
        int n3 = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(n + 1), nArray) : OS.HIComboBoxCopyTextItemAtIndex(this.handle, n, nArray);
        if (n3 != 0) {
            this.error(8);
        }
        int n4 = OS.CFStringGetLength(nArray[0]);
        char[] cArray = new char[n4];
        CFRange cFRange = new CFRange();
        cFRange.length = n4;
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        OS.CFRelease(nArray[0]);
        return new String(cArray);
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return OS.CountMenuItems(this.menuHandle);
        }
        return OS.HIComboBoxGetItemCount(this.handle);
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            MenuTrackingData menuTrackingData = new MenuTrackingData();
            return OS.GetMenuTrackingData(this.menuHandle, menuTrackingData) == 0;
        }
        if (OS.VERSION >= 4160) {
            return OS.HIComboBoxIsListVisible(this.handle);
        }
        return false;
    }

    int getMininumHeight() {
        return this.getTextHeight();
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        ControlEditTextSelectionRec controlEditTextSelectionRec;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selection != null) {
            controlEditTextSelectionRec = this.selection;
        } else {
            controlEditTextSelectionRec = new ControlEditTextSelectionRec();
            OS.GetControlData(this.handle, (short)5, 1936026725, 4, controlEditTextSelectionRec, null);
        }
        return new Point(controlEditTextSelectionRec.selStart, controlEditTextSelectionRec.selEnd);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return OS.GetControlValue(this.handle) - 1;
        }
        return this.indexOf(this.getText());
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int n, int n2) {
        int n3;
        int[] nArray = new int[1];
        if ((this.style & 8) != 0) {
            int n4 = OS.GetControlValue(this.handle) - 1;
            n3 = OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(n4 + 1), nArray);
        } else {
            int[] nArray2 = new int[1];
            n3 = OS.GetControlData(this.handle, (short)5, 1667658612, 4, nArray, nArray2);
        }
        if (n3 != 0) {
            return new char[0];
        }
        CFRange cFRange = new CFRange();
        cFRange.location = n;
        if (n2 == -1) {
            int n5 = OS.CFStringGetLength(nArray[0]);
            cFRange.length = n5 - n;
        } else {
            cFRange.length = n2 - n;
        }
        char[] cArray = new char[cFRange.length];
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        OS.CFRelease(nArray[0]);
        return cArray;
    }

    public int getTextHeight() {
        this.checkWidget();
        return 26;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        int[] nArray = new int[1];
        OS.GetControlData(this.handle, (short)0, 1667395177, 4, nArray, null);
        return nArray[0];
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 8) != 0) {
            int n = this.display.commandProc;
            int[] nArray = new int[]{1668113523, 1};
            int n2 = OS.GetMenuEventTarget(this.menuHandle);
            OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.handle, null);
        }
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            return -1;
        }
        int n3 = n;
        while (n3 < n2) {
            if (string.equals(this.getItem(n3))) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    int getCharCount() {
        int n;
        int n2;
        int[] nArray = new int[1];
        if ((this.style & 8) != 0) {
            n2 = OS.GetControlValue(this.handle) - 1;
            n = OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(n2 + 1), nArray);
        } else {
            int[] nArray2 = new int[1];
            n = OS.GetControlData(this.handle, (short)5, 1667658612, 4, nArray, nArray2);
        }
        if (n != 0) {
            return 0;
        }
        n2 = OS.CFStringGetLength(nArray[0]);
        OS.CFRelease(nArray[0]);
        return n2;
    }

    Rect getInset() {
        return this.display.comboInset;
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        int n4 = -9874;
        if ((this.style & 8) == 0) {
            boolean bl;
            int[] nArray;
            int n5;
            int[] nArray2 = new int[1];
            OS.GetEventParameter(n2, 1635020397, 1667658612, null, 4, null, nArray2);
            int n6 = 0;
            if (nArray2[0] != 0) {
                n6 = OS.CFStringGetLength(nArray2[0]);
            }
            char[] cArray = new char[n6];
            CFRange cFRange = new CFRange();
            cFRange.length = n6;
            OS.CFStringGetCharacters(nArray2[0], cFRange, cArray);
            String string = new String(cArray);
            if (string.equals("AXValue")) {
                cArray = this.getText(0, -1);
                nArray2[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray2[0] != 0) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray2);
                    OS.CFRelease(nArray2[0]);
                    n4 = 0;
                }
            } else if (string.equals("AXNumberOfCharacters")) {
                OS.SetEventParameter(n2, 1635022444, 1819242087, 4, new int[]{this.getCharCount()});
                n4 = 0;
            } else if (string.equals("AXSelectedText")) {
                Point point = this.getSelection();
                cArray = this.getText(point.x, point.y);
                nArray2[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray2[0] != 0) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray2);
                    OS.CFRelease(nArray2[0]);
                    n4 = 0;
                }
            } else if (string.equals("AXSelectedTextRange")) {
                Point point = this.getSelection();
                cFRange = new CFRange();
                cFRange.location = point.x;
                cFRange.length = point.y - point.x;
                int n7 = OS.AXValueCreate(4, cFRange);
                OS.SetEventParameter(n2, 1635022444, 1667658873, 4, new int[]{n7});
                OS.CFRelease(n7);
                n4 = 0;
            } else if (string.equals("AXStringForRange") && (n5 = OS.GetEventParameter(n2, 1635020897, 1667658873, null, 4, null, nArray = new int[1])) == 0 && (bl = OS.AXValueGetValue(nArray[0], 4, cFRange = new CFRange()))) {
                cArray = this.getText(cFRange.location, cFRange.location + cFRange.length);
                nArray2[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray2[0] != 0) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray2);
                    OS.CFRelease(nArray2[0]);
                    n4 = 0;
                }
            }
        }
        if (this.accessible != null) {
            n4 = this.accessible.internal_kEventAccessibleGetNamedAttribute(n, n2, n4);
        }
        return n4;
    }

    int kEventControlActivate(int n, int n2, int n3) {
        int n4 = super.kEventControlActivate(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        return 0;
    }

    int kEventProcessCommand(int n, int n2, int n3) {
        int n4 = super.kEventProcessCommand(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.postEvent(24);
        if (this.isDisposed()) {
            return -9874;
        }
        this.sendSelectionEvent(13);
        return -9874;
    }

    int kEventRawKeyPressed(int n, int n2, int n3) {
        if (OS.VERSION < 4160) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1801678692, 1835100014, null, nArray.length * 4, null, nArray);
            switch (nArray[0]) {
                case 125: 
                case 126: {
                    if (this.sendKeyEvent(1, n2)) break;
                    return 0;
                }
            }
        }
        return -9874;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        int n4 = super.kEventControlSetFocusPart(n, n2, n3);
        if (n4 == 0 && (this.style & 8) == 0) {
            short[] sArray = new short[1];
            OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
            if (sArray[0] != 0) {
                this.display.focusCombo = this;
            }
        }
        return n4;
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        String string = "AXValueChanged";
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n5 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        OS.AXNotificationHIObjectNotify(n5, this.handle, 0L);
        OS.CFRelease(n5);
        string = "AXSelectedTextChanged";
        cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        n5 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        OS.AXNotificationHIObjectNotify(n5, this.handle, 0L);
        OS.CFRelease(n5);
        if (this.hooks(25) || this.filters(25) || this.hooks(24) || this.filters(24)) {
            int[] nArray3 = new int[1];
            OS.GetEventParameter(nArray[0], 1802334052, 1835100014, null, 4, null, nArray3);
            if (nArray3[0] == 256) {
                switch (nArray2[0]) {
                    case 7: {
                        this.cut();
                        return 0;
                    }
                    case 9: {
                        this.paste();
                        return 0;
                    }
                }
            }
        }
        switch (nArray2[0]) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        n4 = OS.CallNextEventHandler(n, n2);
        this.lastText = this.getText();
        return n4;
    }

    public void paste() {
        int n;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        int n2 = point.x;
        int n3 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n3, string.length());
        String string4 = this.getClipboardText();
        if ((this.hooks(25) || this.filters(25)) && (string4 = this.verifyText(string4, n2, n3, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (n = string.length()) - (n3 - n2) + string4.length() > this.textLimit) {
            string4 = string4.substring(0, this.textLimit - n + (n3 - n2));
        }
        this.setText(String.valueOf(string2) + string4 + string3, false);
        this.setSelection(new Point(n2 += string4.length(), n2));
        this.sendEvent(24);
    }

    boolean pollTrackEvent() {
        return true;
    }

    void releaseHandle() {
        if ((this.getShell().state & 0x10000) == 0) {
            if ((this.style & 4) != 0) {
                OS.HIViewSetFrame(this.handle, new CGRect());
            }
            this.display.addToDisposeWindow(this.handle);
        }
        super.releaseHandle();
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.focusCombo == this) {
            this.display.focusCombo = null;
        }
        if (this.menuHandle != 0) {
            OS.DisposeMenu(this.menuHandle);
        }
        this.menuHandle = 0;
    }

    public void remove(int n) {
        this.checkWidget();
        if (n == -1) {
            this.error(6);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems(this.menuHandle, (short)(n + 1), 1);
            if (n == OS.GetControlValue(this.handle) - 1) {
                OS.SetControl32BitValue(this.handle, 0);
            }
        } else {
            OS.HIComboBoxRemoveItemAtIndex(this.handle, n);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = this.getItemCount();
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = Math.min(n2, n3 - 1);
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems(this.menuHandle, (short)(n + 1), n4 - n + 1);
            int n5 = OS.GetControlValue(this.handle) - 1;
            if (n <= n5 && n5 <= n2) {
                OS.SetControl32BitValue(this.handle, 0);
            }
        } else {
            int n6 = n4;
            while (n6 >= n) {
                OS.HIComboBoxRemoveItemAtIndex(this.handle, n6);
                --n6;
            }
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.getItemCount();
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems(this.menuHandle, (short)1, n);
            OS.SetControl32BitValue(this.handle, 0);
        } else {
            this.setText("", true);
            if (n > 0) {
                int n2 = n - 1;
                while (n2 >= 0) {
                    OS.HIComboBoxRemoveItemAtIndex(this.handle, n2);
                    --n2;
                }
            }
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n >= 0 && n < n2) {
            if ((this.style & 8) != 0) {
                OS.SetControl32BitValue(this.handle, n + 1);
                this.sendEvent(24);
            } else {
                this.setText(this.getItem(n), true);
            }
        }
    }

    boolean sendKeyEvent(int n, Event event) {
        if (!super.sendKeyEvent(n, event)) {
            return false;
        }
        if (n != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if ((event.stateMask & 0x400000) != 0) {
            return true;
        }
        String string = "";
        String string2 = "";
        if (this.hooks(25) || this.filters(25)) {
            int n2 = this.getCharCount();
            Point point = this.getSelection();
            int n3 = point.x;
            int n4 = point.y;
            switch (event.character) {
                case '\b': {
                    if (n3 != n4) break;
                    if (n3 == 0) {
                        return true;
                    }
                    n3 = Math.max(0, n3 - 1);
                    break;
                }
                case '\u007f': {
                    if (n3 != n4) break;
                    if (n3 == n2) {
                        return true;
                    }
                    n4 = Math.min(n4 + 1, n2);
                    break;
                }
                case '\r': {
                    return true;
                }
                default: {
                    if (event.character != '\t' && event.character < ' ') {
                        return true;
                    }
                    string = new String(new char[]{event.character});
                }
            }
            if ((string2 = this.verifyText(string, n3, n4, event)) == null) {
                return false;
            }
            if (n2 - (n4 - n3) + string2.length() > this.textLimit) {
                return false;
            }
            if (string2 != string) {
                String string3 = this.getText();
                String string4 = string3.substring(0, n3);
                String string5 = string3.substring(n4, string3.length());
                this.setText(String.valueOf(string4) + string2 + string5, false);
                this.setSelection(new Point(n3 += string2.length(), n3));
            }
        }
        this.postEvent(24);
        return string2 == string;
    }

    void setBackground(int n, float[] fArray) {
        if ((this.style & 8) == 0 && fArray == null) {
            fArray = this.defaultBackground().handle;
        }
        super.setBackground(n, fArray);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if ((this.style & 8) != 0) {
            return super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        }
        Rect rect = this.getInset();
        Rectangle rectangle = this.getBounds();
        int n5 = rectangle.width - rect.left - rect.right;
        int n6 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if (n5 == 0 && n3 > 0) {
            Point point = this.getSelection();
            this.setText(this.getText(), false);
            this.setSelection(point);
        }
        return n6;
    }

    public void setItem(int n, String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getItemCount();
        if (n < 0 || n >= n3) {
            this.error(6);
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n4 == 0) {
            this.error(14);
        }
        if ((this.style & 8) != 0) {
            n2 = OS.SetMenuItemTextWithCFString(this.menuHandle, (short)(n + 1), n4);
            if (string.startsWith("-")) {
                OS.ChangeMenuItemAttributes(this.menuHandle, (short)(n + 1), 0, 64);
            }
        } else {
            n2 = OS.HIComboBoxInsertTextItemAtIndex(this.handle, n, n4);
            OS.HIComboBoxRemoveItemAtIndex(this.handle, n + 1);
        }
        OS.CFRelease(n4);
        if (n2 != 0) {
            this.error(14);
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        this.removeAll();
        if (stringArray.length == 0) {
            return;
        }
        n = 0;
        while (n < stringArray.length) {
            int n2;
            String string = stringArray[n];
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n3 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            if (n3 == 0) {
                this.error(14);
            }
            if ((this.style & 8) != 0) {
                n2 = OS.AppendMenuItemTextWithCFString(this.menuHandle, n3, 0, 0, null);
                if (string.startsWith("-")) {
                    OS.ChangeMenuItemAttributes(this.menuHandle, (short)(n + 1), 0, 64);
                }
            } else {
                int[] nArray = new int[1];
                n2 = OS.HIComboBoxAppendTextItem(this.handle, n3, nArray);
            }
            OS.CFRelease(n3);
            if (n2 != 0) {
                this.error(14);
            }
            ++n;
        }
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            if (bl) {
                OS.HIViewSimulateClick(this.handle, (short)0, 0, null);
            } else {
                OS.CancelMenuTracking(this.menuHandle, true, 0);
            }
        } else if (OS.VERSION >= 4160) {
            OS.HIComboBoxSetListVisible(this.handle, bl);
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            int n = this.getCharCount();
            int n2 = point.x;
            int n3 = point.y;
            ControlEditTextSelectionRec controlEditTextSelectionRec = new ControlEditTextSelectionRec();
            controlEditTextSelectionRec.selStart = (short)Math.min(Math.max(Math.min(n2, n3), 0), n);
            controlEditTextSelectionRec.selEnd = (short)Math.min(Math.max(Math.max(n2, n3), 0), n);
            if (this.hasFocus()) {
                OS.SetControlData(this.handle, 5, 1936026725, 4, controlEditTextSelectionRec);
            } else {
                this.selection = controlEditTextSelectionRec;
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean bl) {
        if (bl && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1 && n != this.getSelectionIndex()) {
                this.select(n);
                if (bl) {
                    this.sendEvent(24);
                }
            }
        } else {
            char[] cArray = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, cArray.length, cArray, 0);
            int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            if (n == 0) {
                this.error(13);
            }
            this.lastText = string;
            OS.SetControlData(this.handle, 5, 1667658612, 4, new int[]{n});
            OS.CFRelease(n);
            this.setSelection(new Point(0, 0));
            if (bl) {
                this.sendEvent(24);
            }
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        this.textLimit = n;
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            OS.SetControlData(this.handle, 0, 1667395177, 4, new int[]{n});
        }
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }
}

