/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean open;
    int fontID;
    int fontSize;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    int fontProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        block0 : switch (n4) {
            case 1: {
                this.open = false;
                break;
            }
            case 2: {
                RGBColor rGBColor;
                int[] nArray;
                int[] nArray2;
                int[] nArray3 = new int[1];
                if (OS.GetEventParameter(n2, 1635084644, 1835100014, null, 4, null, nArray3) == 0) {
                    this.fontID = nArray3[0];
                }
                if (OS.GetEventParameter(n2, 1635087226, 1718188132, null, 4, null, nArray2 = new int[1]) == 0) {
                    this.fontSize = nArray2[0];
                }
                if (OS.GetEventParameter(n2, 1717791858, 1666336578, null, 6, nArray = new int[1], rGBColor = new RGBColor()) == 0) {
                    int n5 = rGBColor.red >> 8 & 0xFF;
                    int n6 = rGBColor.green >> 8 & 0xFF;
                    int n7 = rGBColor.blue >> 8 & 0xFF;
                    this.rgb = new RGB(n5, n6, n7);
                    break;
                }
                int[] nArray4 = new int[1];
                if (OS.GetEventParameter(n2, 1684628340, 0x63666463, null, 4, nArray, nArray4) != 0) break;
                int[] nArray5 = new int[1];
                if (!OS.CFDictionaryGetValueIfPresent(nArray4[0], OS.kFontPanelAttributesKey(), nArray5)) break;
                int[] nArray6 = new int[1];
                int[] nArray7 = new int[1];
                int[] nArray8 = new int[1];
                if (!OS.CFDictionaryGetValueIfPresent(nArray5[0], OS.kFontPanelAttributeTagsKey(), nArray6) || !OS.CFDictionaryGetValueIfPresent(nArray5[0], OS.kFontPanelAttributeSizesKey(), nArray7) || !OS.CFDictionaryGetValueIfPresent(nArray5[0], OS.kFontPanelAttributeValuesKey(), nArray8)) break;
                int n8 = OS.CFDataGetLength(nArray6[0]) / 4;
                int n9 = OS.CFDataGetBytePtr(nArray6[0]);
                int n10 = OS.CFDataGetBytePtr(nArray7[0]);
                int[] nArray9 = new int[1];
                int[] nArray10 = new int[1];
                int n11 = 0;
                int n12 = 0;
                while (n12 < n8) {
                    OS.memmove(nArray9, n9 + n12 * 4, 4);
                    OS.memmove(nArray10, n10 + n12 * 4, 4);
                    if (nArray9[0] == 263 && nArray10[0] == 6) {
                        int n13 = OS.CFDataGetBytePtr(nArray8[0]);
                        OS.memmove(rGBColor, n13 + n11, 6);
                        int n14 = rGBColor.red >> 8 & 0xFF;
                        int n15 = rGBColor.green >> 8 & 0xFF;
                        int n16 = rGBColor.blue >> 8 & 0xFF;
                        this.rgb = new RGB(n14, n15, n16);
                        break block0;
                    }
                    n11 = nArray10[0];
                    ++n12;
                }
                break;
            }
        }
        return 0;
    }

    public FontData open() {
        int n;
        int n2;
        Object object;
        Display display;
        Display display2 = display = this.parent != null ? this.parent.display : Display.getCurrent();
        if (this.fontData != null) {
            object = new Font((Device)display, this.fontData);
            int n3 = OS.NewPtr(4);
            OS.memmove(n3, new int[]{((Font)object).atsuiStyle}, 4);
            OS.SetFontInfoForSelection(1634956396, 1, n3, 0);
            OS.DisposePtr(n3);
            ((Resource)object).dispose();
        }
        object = new int[]{1718578804, 2, 1718578804, 1};
        Callback callback = new Callback(this, "fontProc", 3);
        int n4 = callback.getAddress();
        if (n4 == 0) {
            SWT.error(3);
        }
        int n5 = OS.GetApplicationEventTarget();
        int[] nArray = new int[1];
        OS.InstallEventHandler(n5, n4, ((Object)object).length / 2, (int[])object, 0, nArray);
        this.fontID = 0;
        this.fontSize = 0;
        this.fontData = null;
        this.rgb = null;
        this.open = true;
        int n6 = 0;
        int n7 = OS.GetPreviousWindow(0);
        while (n7 != 0) {
            ++n6;
            n7 = OS.GetPreviousWindow(n7);
        }
        int[] nArray2 = new int[n6];
        boolean[] blArray = new boolean[n6];
        n6 = 0;
        n7 = OS.GetPreviousWindow(0);
        while (n7 != 0) {
            nArray2[n6] = n7;
            blArray[n6] = OS.IsWindowVisible(n7);
            ++n6;
            n7 = OS.GetPreviousWindow(n7);
        }
        display.setModalDialog(this);
        OS.FPShowHideFontPanel();
        int n8 = 0;
        n7 = OS.GetPreviousWindow(0);
        while (n7 != 0 && n8 == 0) {
            if (OS.IsWindowVisible(n7)) {
                n2 = 0;
                n = 0;
                while (n < nArray2.length) {
                    if (nArray2[n] == n7) {
                        n2 = 1;
                        if (!blArray[n]) {
                            n8 = n7;
                            break;
                        }
                    }
                    ++n;
                }
                if (n2 == 0) {
                    n8 = n7;
                    break;
                }
            }
            n7 = OS.GetPreviousWindow(n7);
        }
        if (n8 != 0) {
            n2 = 0;
            if ((this.style & 0x8000) != 0) {
                n2 = 3;
            }
            if ((this.style & 0x10000) != 0) {
                n2 = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n2 = 1;
            }
            if (n2 != 0) {
                n = 0;
                if (this.parent != null) {
                    n = OS.GetControlOwner(this.parent.handle);
                }
                OS.SetWindowModality(n8, n2, n);
                OS.SelectWindow(n8);
            }
        }
        while (!this.parent.isDisposed() && this.open) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.setModalDialog(null);
        OS.RemoveEventHandler(nArray[0]);
        callback.dispose();
        if (this.fontID != 0 && this.fontSize != 0) {
            n2 = OS.FMGetATSFontRefFromFont(this.fontID);
            Font font = Font.carbon_new(display, n2, (short)0, (float)OS.Fix2X(this.fontSize));
            this.fontData = font.getFontData()[0];
            font.dispose();
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

