/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    public ProgressBar(Composite composite, int n) {
        super(composite, ProgressBar.checkStyle(n));
    }

    static int checkStyle(int n) {
        return ProgressBar.checkBits(n |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.GetThemeMetric(58, nArray);
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            n4 = nArray[0];
            n3 = n4 * 10;
        } else {
            n3 = nArray[0];
            n4 = n3 * 10;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        int[] nArray = new int[1];
        int n = OS.GetControlOwner(this.parent.handle);
        OS.CreateProgressBarControl(n, null, 0, 0, 100, (this.style & 2) != 0, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
    }

    void drawBackground(int n, int n2) {
        this.fillBackground(n, n2, null);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.GetControl32BitMaximum(this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum(this.handle);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.handle);
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMinimum(this.handle);
        if (n > n2) {
            OS.SetControl32BitMaximum(this.handle, n);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMaximum(this.handle);
        if (n < n2) {
            OS.SetControl32BitMinimum(this.handle, n);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.SetControl32BitValue(this.handle, n);
        this.update(false);
    }

    public void setState(int n) {
        this.checkWidget();
    }
}

