/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    boolean dragging;
    int increment = 1;
    int pageIncrement = 10;

    public Slider(Composite composite, int n) {
        super(composite, Slider.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Slider.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    int actionProc(int n, int n2) {
        int n3 = super.actionProc(n, n2);
        if (n3 == 0) {
            return n3;
        }
        Event event = new Event();
        int n4 = OS.GetControl32BitValue(this.handle);
        switch (n2) {
            case 20: {
                n4 -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 22: {
                n4 -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 23: {
                n4 += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 21: {
                n4 += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 129: {
                this.dragging = true;
                event.detail = 1;
                break;
            }
            default: {
                return n3;
            }
        }
        OS.SetControl32BitValue(this.handle, n4);
        this.sendSelectionEvent(13, event, true);
        return n3;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.GetThemeMetric(0, nArray);
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            n4 = nArray[0];
            n3 = n4 * 10;
        } else {
            n3 = nArray[0];
            n4 = n3 * 10;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        int n = this.display.actionProc;
        int[] nArray = new int[1];
        int n2 = OS.GetControlOwner(this.parent.handle);
        OS.CreateScrollBarControl(n2, null, 0, 0, 90, 10, true, n, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
    }

    void drawBackground(int n, int n2) {
        this.fillBackground(n, n2, null);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int n = OS.GetControl32BitMaximum(this.handle);
        int n2 = OS.GetControlViewSize(this.handle);
        return n + n2;
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.handle);
    }

    public int getThumb() {
        this.checkWidget();
        return OS.GetControlViewSize(this.handle);
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4 = super.kEventMouseDown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.dragging = false;
        n4 = OS.CallNextEventHandler(n, n2);
        if (this.dragging) {
            Event event = new Event();
            this.sendSelectionEvent(13, event, true);
        }
        this.dragging = false;
        return n4;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.increment = n;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMinimum(this.handle);
        if (n <= n2) {
            return;
        }
        int n3 = OS.GetControlViewSize(this.handle);
        if (n - n2 < n3) {
            n3 = n - n2;
            OS.SetControlViewSize(this.handle, n3);
        }
        OS.SetControl32BitMaximum(this.handle, n - n3);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControlViewSize(this.handle);
        int n3 = OS.GetControl32BitMaximum(this.handle) + n2;
        if (n >= n3) {
            return;
        }
        if (n3 - n < n2) {
            n2 = n3 - n;
            OS.SetControl32BitMaximum(this.handle, n3 - n2);
            OS.SetControlViewSize(this.handle, n2);
        }
        OS.SetControl32BitMinimum(this.handle, n);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.SetControl32BitValue(this.handle, n);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.GetControl32BitMinimum(this.handle);
        int n3 = OS.GetControlViewSize(this.handle);
        int n4 = OS.GetControl32BitMaximum(this.handle) + n3;
        n = Math.min(n, n4 - n2);
        OS.SetControl32BitMaximum(this.handle, n4 - n);
        OS.SetControlViewSize(this.handle, n);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        OS.SetControl32BitMinimum(this.handle, n2);
        OS.SetControl32BitMaximum(this.handle, n3 - n4);
        OS.SetControlViewSize(this.handle, n4);
        OS.SetControl32BitValue(this.handle, n);
        this.increment = n5;
        this.pageIncrement = n6;
    }
}

