/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.FLICK_DATA;
import org.eclipse.swt.internal.win32.FLICK_POINT;
import org.eclipse.swt.internal.win32.GESTURECONFIG;
import org.eclipse.swt.internal.win32.GESTUREINFO;
import org.eclipse.swt.internal.win32.HELPINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOUCHINPUT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Touch;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public long handle;
    Composite parent;
    Cursor cursor;
    Menu menu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Image backgroundImage;
    Region region;
    Font font;
    int drawCount;
    int foreground;
    int background;

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(gestureListener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    public void addTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(touchListener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            if (nArray[n6] == n3) {
                return n6;
            }
            if (nArray[n6] < n3) {
                n4 = n6 + 1;
                continue;
            }
            n5 = n6 - 1;
        }
        return -n4 - 1;
    }

    long borderHandle() {
        return this.handle;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0) {
                if (n == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x100) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBorder() {
        if (this.getBorderWidth() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkBuffered() {
        this.style &= 0xDFFFFFFF;
    }

    void checkComposited() {
    }

    boolean checkHandle(long l) {
        return l == this.handle;
    }

    void checkMirrored() {
        int n;
        if ((this.style & 0x4000000) != 0 && ((n = OS.GetWindowLong(this.handle, -20)) & 0x400000) != 0) {
            this.style |= 0x8000000;
        }
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 64;
        int n4 = 64;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n;
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    void createHandle() {
        int n;
        long l = this.widgetParent();
        this.handle = OS.CreateWindowEx(this.widgetExtStyle(), this.windowClass(), null, this.widgetStyle(), Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, l, 0L, OS.GetModuleHandle(null), this.widgetCreateStruct());
        if (this.handle == 0L) {
            this.error(2);
        }
        if (((n = OS.GetWindowLong(this.handle, -16)) & 0x40000000) != 0) {
            OS.SetWindowLongPtr(this.handle, -12, this.handle);
        }
        if (OS.IsDBLocale && l != 0L) {
            long l2 = OS.ImmGetContext(l);
            OS.ImmAssociateContext(this.handle, l2);
            OS.ImmReleaseContext(l, l2);
        }
    }

    void checkGesture() {
        long l;
        long l2;
        int n;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1) && ((n = OS.GetSystemMetrics(94)) & 0xC0) != 0 && (l2 = OS.HeapAlloc(l = OS.GetProcessHeap(), 8, GESTURECONFIG.sizeof)) != 0L) {
            GESTURECONFIG gESTURECONFIG = new GESTURECONFIG();
            gESTURECONFIG.dwID = 5;
            gESTURECONFIG.dwWant = 1;
            gESTURECONFIG.dwBlock = 0;
            OS.MoveMemory(l2, gESTURECONFIG, GESTURECONFIG.sizeof);
            OS.SetGestureConfig(this.handle, 0, 1, l2, GESTURECONFIG.sizeof);
            OS.HeapFree(l, 0, l2);
        }
    }

    void createWidget() {
        this.state |= 0x8000;
        this.background = -1;
        this.foreground = -1;
        this.checkOrientation(this.parent);
        this.createHandle();
        this.checkBackground();
        this.checkBuffered();
        this.checkComposited();
        this.register();
        this.subclass();
        this.setDefaultFont();
        this.checkMirrored();
        this.checkBorder();
        this.checkGesture();
        if ((this.state & 0x400) != 0) {
            this.setBackground();
        }
    }

    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    long defaultFont() {
        return this.display.getSystemFont().handle;
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
    }

    void deregister() {
        this.display.removeControl(this.handle);
    }

    void destroyWidget() {
        long l = this.topHandle();
        this.releaseHandle();
        if (l != 0L) {
            OS.DestroyWindow(l);
        }
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 || n2 != 1) {
            return false;
        }
        boolean bl = this.dragDetect(this.handle, n4, n5, false, null, null);
        if (OS.GetKeyState(1) < 0 && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (!bl) {
            if (n == 1 && OS.GetKeyState(27) >= 0) {
                int n6 = 0;
                if ((n3 & 0x40000) != 0) {
                    n6 |= 8;
                }
                if ((n3 & 0x20000) != 0) {
                    n6 |= 4;
                }
                if ((n3 & 0x10000) != 0) {
                    n6 |= 0x20;
                }
                if ((n3 & 0x80000) != 0) {
                    n6 |= 1;
                }
                if ((n3 & 0x100000) != 0) {
                    n6 |= 0x10;
                }
                if ((n3 & 0x200000) != 0) {
                    n6 |= 2;
                }
                if ((n3 & 0x800000) != 0) {
                    n6 |= 0x20;
                }
                if ((n3 & 0x2000000) != 0) {
                    n6 |= 0x40;
                }
                long l = OS.MAKELPARAM(n4, n5);
                OS.SendMessage(this.handle, 514, (long)n6, l);
            }
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5);
    }

    void drawBackground(long l) {
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        this.drawBackground(l, rECT);
    }

    void drawBackground(long l, RECT rECT) {
        this.drawBackground(l, rECT, -1, 0, 0);
    }

    void drawBackground(long l, RECT rECT, int n, int n2, int n3) {
        Control control = this.findBackgroundControl();
        if (control != null) {
            if (control.backgroundImage != null) {
                this.fillImageBackground(l, control, rECT, n2, n3);
                return;
            }
            n = control.getBackgroundPixel();
        }
        if (n == -1 && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            this.fillThemeBackground(l, control, rECT);
            return;
        }
        if (n == -1) {
            n = this.getBackgroundPixel();
        }
        this.fillBackground(l, n, rECT);
    }

    void drawImageBackground(long l, long l2, long l3, RECT rECT, int n, int n2) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(l2, rECT2);
        OS.MapWindowPoints(l2, this.handle, rECT2, 2);
        long l4 = this.findBrush(l3, 3);
        POINT pOINT = new POINT();
        OS.GetWindowOrgEx(l, pOINT);
        OS.SetBrushOrgEx(l, -rECT2.left - pOINT.x - n, -rECT2.top - pOINT.y - n2, pOINT);
        long l5 = OS.SelectObject(l, l4);
        OS.PatBlt(l, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
        OS.SetBrushOrgEx(l, pOINT.x, pOINT.y, null);
        OS.SelectObject(l, l5);
    }

    void drawThemeBackground(long l, long l2, RECT rECT) {
    }

    void enableDrag(boolean bl) {
    }

    void enableWidget(boolean bl) {
        OS.EnableWindow(this.handle, bl);
    }

    void fillBackground(long l, int n, RECT rECT) {
        if (rECT.left > rECT.right || rECT.top > rECT.bottom) {
            return;
        }
        long l2 = this.display.hPalette;
        if (l2 != 0L) {
            OS.SelectPalette(l, l2, false);
            OS.RealizePalette(l);
        }
        OS.FillRect(l, rECT, this.findBrush(n, 0));
    }

    void fillImageBackground(long l, Control control, RECT rECT, int n, int n2) {
        Image image;
        if (rECT.left > rECT.right || rECT.top > rECT.bottom) {
            return;
        }
        if (control != null && (image = control.backgroundImage) != null) {
            control.drawImageBackground(l, this.handle, image.handle, rECT, n, n2);
        }
    }

    void fillThemeBackground(long l, Control control, RECT rECT) {
        if (rECT.left > rECT.right || rECT.top > rECT.bottom) {
            return;
        }
        if (control != null) {
            control.drawThemeBackground(l, this.handle, rECT);
        }
    }

    Control findBackgroundControl() {
        if (this.background != -1 || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    long findBrush(long l, int n) {
        return this.parent.findBrush(l, n);
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findImageControl() {
        Control control = this.findBackgroundControl();
        return control != null && control.backgroundImage != null ? control : null;
    }

    Control findThemeControl() {
        return this.background == -1 && this.backgroundImage == null ? this.parent.findThemeControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    char findMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return string.charAt(n);
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        Display display = this.display;
        boolean bl = display.fixFocus;
        display.fixFocus = true;
        try {
            while (control2 != shell && (control2 = control2.parent) != null) {
                if (!control2.setFocus()) continue;
                return;
            }
        }
        finally {
            display.fixFocus = bl;
        }
        shell.setSavedFocus(control);
        OS.SetFocus(0L);
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        decorations.setSavedFocus(null);
        OS.SetFocus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        decorations.setSavedFocus(this);
        return this.isFocusControl();
    }

    void forceResize() {
        if (this.parent == null) {
            return;
        }
        WINDOWPOS[] wINDOWPOSArray = this.parent.lpwp;
        if (wINDOWPOSArray == null) {
            return;
        }
        for (int i = 0; i < wINDOWPOSArray.length; ++i) {
            WINDOWPOS wINDOWPOS = wINDOWPOSArray[i];
            if (wINDOWPOS == null || wINDOWPOS.hwnd != this.handle) continue;
            this.SetWindowPos(wINDOWPOS.hwnd, 0L, wINDOWPOS.x, wINDOWPOS.y, wINDOWPOS.cx, wINDOWPOS.cy, wINDOWPOS.flags);
            wINDOWPOSArray[i] = null;
            return;
        }
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.win32_new(this.display, control.getBackgroundPixel());
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    int getBackgroundPixel() {
        return this.background != -1 ? this.background : this.defaultBackground();
    }

    public int getBorderWidth() {
        this.checkWidget();
        long l = this.borderHandle();
        int n = OS.GetWindowLong(l, -20);
        if ((n & 0x200) != 0) {
            return OS.GetSystemMetrics(45);
        }
        if ((n & 0x20000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        int n2 = OS.GetWindowLong(l, -16);
        if ((n2 & 0x800000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.topHandle(), rECT);
        long l = this.parent == null ? 0L : this.parent.handle;
        OS.MapWindowPoints(0L, l, rECT, 2);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n, n2);
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        long l = OS.SendMessage(this.handle, 49, 0L, 0L);
        LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        OS.GetObject(l, LOGFONT.sizeof, lOGFONT);
        int n = lOGFONT.lfCharSet & 0xFF;
        int[] nArray = new int[8];
        if (OS.TranslateCharsetInfo(n, nArray, 1)) {
            return nArray[1];
        }
        return OS.GetACP();
    }

    String getClipboardText() {
        String string = "";
        if (OS.OpenClipboard(0L)) {
            long l = OS.GetClipboardData(OS.IsUnicode ? 13 : 1);
            if (l != 0L) {
                int n = OS.GlobalSize(l) / TCHAR.sizeof * TCHAR.sizeof;
                long l2 = OS.GlobalLock(l);
                if (l2 != 0L) {
                    TCHAR tCHAR = new TCHAR(0, n / TCHAR.sizeof);
                    OS.MoveMemory(tCHAR, l2, n);
                    string = tCHAR.toString(0, tCHAR.strlen());
                    OS.GlobalUnlock(l);
                }
            }
            OS.CloseClipboard();
        }
        return string;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x8000) != 0;
    }

    boolean getDrawing() {
        return this.drawCount <= 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.IsWindowEnabled(this.handle);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        long l = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l == 0L) {
            l = this.defaultFont();
        }
        return Font.win32_new(this.display, l);
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getForegroundPixel());
    }

    int getForegroundPixel() {
        return this.foreground != -1 ? this.foreground : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.topHandle(), rECT);
        long l = this.parent == null ? 0L : this.parent.handle;
        OS.MapWindowPoints(0L, l, rECT, 2);
        return new Point(rECT.left, rECT.top);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return this.display.getPrimaryMonitor();
        }
        long l = OS.MonitorFromWindow(this.handle, 2);
        MONITORINFO mONITORINFO = new MONITORINFO();
        mONITORINFO.cbSize = MONITORINFO.sizeof;
        OS.GetMonitorInfo(l, mONITORINFO);
        Monitor monitor = new Monitor();
        monitor.handle = l;
        monitor.x = mONITORINFO.rcMonitor_left;
        monitor.y = mONITORINFO.rcMonitor_top;
        monitor.width = mONITORINFO.rcMonitor_right - mONITORINFO.rcMonitor_left;
        monitor.height = mONITORINFO.rcMonitor_bottom - mONITORINFO.rcMonitor_top;
        monitor.clientX = mONITORINFO.rcWork_left;
        monitor.clientY = mONITORINFO.rcWork_top;
        monitor.clientWidth = mONITORINFO.rcWork_right - mONITORINFO.rcWork_left;
        monitor.clientHeight = mONITORINFO.rcWork_bottom - mONITORINFO.rcWork_top;
        return monitor;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.topHandle(), rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Point(n, n2);
    }

    public int getTextDirection() {
        this.checkWidget();
        int n = 0x402000;
        int n2 = OS.GetWindowLong(this.handle, -20) & n;
        return n2 == 0 || n2 == n ? 0x2000000 : 0x4000000;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return OS.IsTouchWindow(this.handle, null);
    }

    public boolean getVisible() {
        this.checkWidget();
        if (!this.getDrawing()) {
            return (this.state & 0x10) == 0;
        }
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 0x10000000) != 0;
    }

    boolean hasCursor() {
        RECT rECT = new RECT();
        if (!OS.GetClientRect(this.handle, rECT)) {
            return false;
        }
        OS.MapWindowPoints(this.handle, 0L, rECT, 2);
        POINT pOINT = new POINT();
        return OS.GetCursorPos(pOINT) && OS.PtInRect(rECT, pOINT);
    }

    boolean hasFocus() {
        long l = OS.GetFocus();
        while (l != 0L) {
            if (l == this.handle) {
                return true;
            }
            if (this.display.getControl(l) != null) {
                return false;
            }
            l = OS.GetParent(l);
        }
        return false;
    }

    public long internal_new_GC(GCData gCData) {
        this.checkWidget();
        long l = this.handle;
        if (gCData != null && gCData.hwnd != 0L) {
            l = gCData.hwnd;
        }
        if (gCData != null) {
            gCData.hwnd = l;
        }
        long l2 = 0L;
        l2 = gCData == null || gCData.ps == null ? OS.GetDC(l) : OS.BeginPaint(l, gCData.ps);
        if (l2 == 0L) {
            this.error(2);
        }
        if (gCData != null) {
            int n;
            Control control;
            int n2;
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                n2 = 0x6000000;
                if ((gCData.style & n2) != 0) {
                    gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
                } else {
                    int n3 = OS.GetLayout(l2);
                    gCData.style = (n3 & 1) != 0 ? (gCData.style |= 0xC000000) : (gCData.style |= 0x2000000);
                }
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.display;
            n2 = this.getForegroundPixel();
            if (n2 != OS.GetTextColor(l2)) {
                gCData.foreground = n2;
            }
            if ((control = this.findBackgroundControl()) == null) {
                control = this;
            }
            if ((n = control.getBackgroundPixel()) != OS.GetBkColor(l2)) {
                gCData.background = n;
            }
            gCData.font = this.font != null ? this.font : Font.win32_new(this.display, OS.SendMessage(l, 49, 0L, 0L));
            gCData.uiState = (int)OS.SendMessage(l, 297, 0L, 0L);
        }
        return l2;
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        this.checkWidget();
        long l2 = this.handle;
        if (gCData != null && gCData.hwnd != 0L) {
            l2 = gCData.hwnd;
        }
        if (gCData == null || gCData.ps == null) {
            OS.ReleaseDC(l2, l);
        } else {
            OS.EndPaint(l2, gCData.ps);
        }
    }

    boolean isActive() {
        Shell shell;
        Dialog dialog = this.display.getModalDialog();
        if (dialog != null && (shell = dialog.parent) != null && !shell.isDisposed() && shell != this.getShell()) {
            return false;
        }
        shell = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n = 196608;
            int n2 = shellArray.length;
            while (--n2 >= 0) {
                Shell shell2 = shellArray[n2];
                if (shell2 == null) continue;
                if ((shell2.style & n) != 0) {
                    Control control = this;
                    while (control != null && control != shell2) {
                        control = control.parent;
                    }
                    if (control == shell2) break;
                    return false;
                }
                if ((shell2.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (shell2.parent != shell) continue;
                return false;
            }
        }
        if (shell == null) {
            shell = this.getShell();
        }
        return shell.getEnabled();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return true;
            }
        }
        return ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return false;
            }
        }
        if (((n = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0) {
            return false;
        }
        long l = OS.SendMessage(this.handle, 135, 0L, 0L);
        if ((l & 0x100L) != 0L) {
            return false;
        }
        if ((l & 4L) != 0L) {
            return false;
        }
        if ((l & 1L) != 0L) {
            return false;
        }
        return (l & 2L) == 0L;
    }

    public boolean isVisible() {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            return true;
        }
        return this.getVisible() && this.parent.isVisible();
    }

    void mapEvent(long l, Event event) {
        if (l != this.handle) {
            POINT pOINT = new POINT();
            pOINT.x = event.x;
            pOINT.y = event.y;
            OS.MapWindowPoints(l, this.handle, pOINT, 1);
            event.x = pOINT.x;
            event.y = pOINT.y;
        }
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c) {
        return false;
    }

    boolean mnemonicMatch(char c) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        long l = this.topHandle();
        long l2 = 0L;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            long l3 = control.topHandle();
            if (l3 == 0L || l3 == l) {
                return;
            }
            l2 = OS.GetWindow(l3, 3);
            if (l2 == 0L || l2 == l3) {
                l2 = 0L;
            }
        }
        int n = 19;
        this.SetWindowPos(l, l2, 0, 0, 0, 0, n);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        long l = this.topHandle();
        long l2 = 1L;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            l2 = control.topHandle();
        } else {
            Shell shell = this.getShell();
            if (this == shell && this.parent != null) {
                long l3;
                long l4 = l3 = this.parent.handle;
                l2 = OS.GetWindow(l4, 3);
                while (l2 != 0L && l2 != l4 && OS.GetWindow(l2, 4) != l3) {
                    l4 = l2;
                    l2 = OS.GetWindow(l4, 3);
                }
                if (l2 == l4) {
                    return;
                }
            }
        }
        if (l2 == 0L || l2 == l) {
            return;
        }
        int n = 19;
        this.SetWindowPos(l, l2, 0, 0, 0, 0, n);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    GC new_GC(GCData gCData) {
        return GC.win32_new(this, gCData);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl));
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            long l = this.topHandle();
            long l2 = gC.handle;
            int n = 0;
            long l3 = gC.getGCData().gdipGraphics;
            if (l3 != 0L) {
                long l4 = 0L;
                Gdip.Graphics_SetPixelOffsetMode(l3, 3);
                long l5 = Gdip.Region_new();
                if (l5 == 0L) {
                    this.error(2);
                }
                Gdip.Graphics_GetClip(l3, l5);
                if (!Gdip.Region_IsInfinite(l5, l3)) {
                    l4 = Gdip.Region_GetHRGN(l5, l3);
                }
                Gdip.Region_delete(l5);
                Gdip.Graphics_SetPixelOffsetMode(l3, 4);
                float[] fArray = null;
                long l6 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                if (l6 == 0L) {
                    this.error(2);
                }
                Gdip.Graphics_GetTransform(l3, l6);
                if (!Gdip.Matrix_IsIdentity(l6)) {
                    fArray = new float[6];
                    Gdip.Matrix_GetElements(l6, fArray);
                }
                Gdip.Matrix_delete(l6);
                l2 = Gdip.Graphics_GetHDC(l3);
                n = OS.SaveDC(l2);
                if (fArray != null) {
                    OS.SetGraphicsMode(l2, 2);
                    OS.SetWorldTransform(l2, fArray);
                }
                if (l4 != 0L) {
                    OS.SelectClipRgn(l2, l4);
                    OS.DeleteObject(l4);
                }
            }
            if (OS.IsWinCE) {
                OS.UpdateWindow(l);
            } else {
                int n2 = 384;
                OS.RedrawWindow(l, null, 0L, n2);
            }
            this.printWidget(l, l2, gC);
            if (l3 != 0L) {
                OS.RestoreDC(l2, n);
                Gdip.Graphics_ReleaseHDC(l3, l2);
            }
            return true;
        }
        return false;
    }

    void printWidget(long l, long l2, GC gC) {
        boolean bl = false;
        if (OS.GetDeviceCaps(gC.handle, 2) != 2) {
            int n;
            long l3;
            boolean bl2;
            long l4;
            long l5 = l4 = OS.GetParent(l);
            while (OS.GetParent(l5) != 0L && OS.GetWindow(l5, 4) == 0L) {
                l5 = OS.GetParent(l5);
            }
            RECT rECT = new RECT();
            OS.GetWindowRect(l, rECT);
            boolean bl3 = bl2 = !OS.IsWindowVisible(l);
            if (!bl2) {
                RECT rECT2 = new RECT();
                OS.GetWindowRect(l5, rECT2);
                OS.IntersectRect(rECT2, rECT, rECT2);
                boolean bl4 = bl2 = !OS.EqualRect(rECT2, rECT);
            }
            if (!bl2) {
                long l6 = OS.CreateRectRgn(0, 0, 0, 0);
                l3 = OS.GetParent(l);
                while (l3 != l5 && !bl2) {
                    if (OS.GetWindowRgn(l3, l6) != 0) {
                        bl2 = true;
                    }
                    l3 = OS.GetParent(l3);
                }
                OS.DeleteObject(l6);
            }
            int n2 = OS.GetWindowLong(l, -16);
            int n3 = OS.GetWindowLong(l, -20);
            l3 = OS.GetWindow(l, 3);
            if (l3 == 0L || l3 == l) {
                l3 = 0L;
            }
            if (bl2) {
                n = OS.GetSystemMetrics(76);
                int n4 = OS.GetSystemMetrics(77);
                int n5 = OS.GetSystemMetrics(78);
                int n6 = OS.GetSystemMetrics(79);
                int n7 = 53;
                if ((n2 & 0x10000000) != 0) {
                    OS.DefWindowProc(l, 11, 0L, 0L);
                }
                this.SetWindowPos(l, 0L, n + n5, n4 + n6, 0, 0, n7);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.SetWindowLong(l, -16, n2 & 0xBFFFFFFF | Integer.MIN_VALUE);
                    OS.SetWindowLong(l, -20, n3 | 0x80);
                }
                Shell shell = this.getShell();
                Control control = shell.savedFocus;
                OS.SetParent(l, 0L);
                shell.setSavedFocus(control);
                if ((n2 & 0x10000000) != 0) {
                    OS.DefWindowProc(l, 11, 1L, 0L);
                }
            }
            if ((n2 & 0x10000000) == 0) {
                OS.ShowWindow(l, 5);
            }
            bl = OS.PrintWindow(l, l2, 0);
            if ((n2 & 0x10000000) == 0) {
                OS.ShowWindow(l, 0);
            }
            if (bl2) {
                if ((n2 & 0x10000000) != 0) {
                    OS.DefWindowProc(l, 11, 0L, 0L);
                }
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.SetWindowLong(l, -16, n2);
                    OS.SetWindowLong(l, -20, n3);
                }
                OS.SetParent(l, l4);
                OS.MapWindowPoints(0L, l4, rECT, 2);
                n = 49;
                this.SetWindowPos(l, l3, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, n);
                if ((n2 & 0x10000000) != 0) {
                    OS.DefWindowProc(l, 11, 1L, 0L);
                }
            }
        }
        if (!bl) {
            int n = 30;
            OS.SendMessage(l, 791, l2, (long)n);
        }
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean bl) {
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n = 1029;
            if (bl) {
                n |= 0x80;
            }
            OS.RedrawWindow(this.handle, null, 0L, n);
        }
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, rECT, true);
        } else {
            int n5 = 1029;
            if (bl) {
                n5 |= 0x80;
            }
            OS.RedrawWindow(this.handle, rECT, 0L, n5);
        }
    }

    boolean redrawChildren() {
        if (!OS.IsWindowVisible(this.handle)) {
            return false;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                OS.InvalidateRect(this.handle, null, true);
                return true;
            }
        } else if (control.backgroundImage != null) {
            OS.InvalidateRect(this.handle, null, true);
            return true;
        }
        return false;
    }

    void register() {
        this.display.addControl(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0L;
        this.parent = null;
    }

    void releaseParent() {
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (OS.IsDBLocale) {
            OS.ImmAssociateContext(this.handle, 0L);
        }
        if (this.toolTipText != null) {
            this.setToolTipText(this.getShell(), null);
        }
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.backgroundImage = null;
        this.menu = null;
        this.cursor = null;
        this.unsubclass();
        this.deregister();
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
        this.font = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, gestureListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    public void removeTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, touchListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    void showWidget(boolean bl) {
        long l = this.topHandle();
        OS.ShowWindow(l, bl ? 5 : 0);
        if (this.handle != l) {
            OS.ShowWindow(this.handle, bl ? 5 : 0);
        }
    }

    boolean sendFocusEvent(int n) {
        Shell shell = this.getShell();
        Display display = this.display;
        display.focusEvent = n;
        display.focusControl = this;
        this.sendEvent(n);
        display.focusEvent = 0;
        display.focusControl = null;
        if (!shell.isDisposed()) {
            switch (n) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
        return true;
    }

    boolean sendGestureEvent(GESTUREINFO gESTUREINFO) {
        if (gESTUREINFO.hwndTarget != this.handle) {
            return true;
        }
        Event event = new Event();
        int n = 0;
        Point point = new Point(gESTUREINFO.x, gESTUREINFO.y);
        Point point2 = this.toControl(point);
        event.x = point2.x;
        event.y = point2.y;
        switch (gESTUREINFO.dwID) {
            case 3: {
                n = 48;
                event.detail = 32;
                int n2 = OS.LODWORD(gESTUREINFO.ullArguments);
                if ((gESTUREINFO.dwFlags & 1) != 0) {
                    event.detail = 2;
                    this.display.magStartDistance = this.display.lastDistance = (double)n2;
                } else if ((gESTUREINFO.dwFlags & 4) != 0) {
                    event.detail = 4;
                }
                if ((double)n2 == this.display.lastDistance && event.detail == 32) {
                    return true;
                }
                if (n2 != 0) {
                    event.magnification = (double)n2 / this.display.magStartDistance;
                }
                this.display.lastDistance = n2;
                break;
            }
            case 4: {
                n = 48;
                event.detail = 64;
                if ((gESTUREINFO.dwFlags & 1) != 0) {
                    event.detail = 2;
                    this.display.lastX = point2.x;
                    this.display.lastY = point2.y;
                } else if ((gESTUREINFO.dwFlags & 4) != 0) {
                    event.detail = 4;
                }
                if (this.display.lastX == point2.x && this.display.lastY == point2.y && event.detail == 64) {
                    return true;
                }
                event.xDirection = point2.x - this.display.lastX;
                event.yDirection = point2.y - this.display.lastY;
                this.display.lastX = point2.x;
                this.display.lastY = point2.y;
                break;
            }
            case 5: {
                n = 48;
                event.detail = 8;
                double d = OS.GID_ROTATE_ANGLE_FROM_ARGUMENT(OS.LODWORD(gESTUREINFO.ullArguments));
                if ((gESTUREINFO.dwFlags & 1) != 0) {
                    event.detail = 2;
                    this.display.rotationAngle = d;
                } else if ((gESTUREINFO.dwFlags & 4) != 0) {
                    event.detail = 4;
                }
                if (this.display.rotationAngle == d && event.detail == 8) {
                    return true;
                }
                event.rotation = d * 180.0 / Compatibility.PI;
                this.display.rotationAngle = d;
                break;
            }
        }
        if (n == 0) {
            return true;
        }
        this.setInputState(event, n);
        this.sendEvent(n, event);
        return event.doit;
    }

    void sendMove() {
        this.sendEvent(10);
    }

    void sendResize() {
        this.sendEvent(11);
    }

    void sendTouchEvent(TOUCHINPUT[] tOUCHINPUTArray) {
        Event event = new Event();
        POINT pOINT = new POINT();
        OS.GetCursorPos(pOINT);
        OS.ScreenToClient(this.handle, pOINT);
        event.x = pOINT.x;
        event.y = pOINT.y;
        Touch[] touchArray = new Touch[tOUCHINPUTArray.length];
        Monitor monitor = this.getMonitor();
        for (int i = 0; i < tOUCHINPUTArray.length; ++i) {
            TOUCHINPUT tOUCHINPUT = tOUCHINPUTArray[i];
            TouchSource touchSource = this.display.findTouchSource(tOUCHINPUT.hSource, monitor);
            int n = 0;
            if ((tOUCHINPUT.dwFlags & 2) != 0) {
                n = 1;
            }
            if ((tOUCHINPUT.dwFlags & 4) != 0) {
                n = 4;
            }
            if ((tOUCHINPUT.dwFlags & 1) != 0) {
                n = 2;
            }
            boolean bl = (tOUCHINPUT.dwFlags & 0x10) != 0;
            int n2 = (int)OS.TOUCH_COORD_TO_PIXEL(tOUCHINPUT.x);
            int n3 = (int)OS.TOUCH_COORD_TO_PIXEL(tOUCHINPUT.y);
            touchArray[i] = new Touch(tOUCHINPUT.dwID, touchSource, n, bl, n2, n3);
        }
        event.touches = touchArray;
        this.setInputState(event, 47);
        this.postEvent(47, event);
    }

    void setBackground() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            Shell shell = this.getShell();
            shell.releaseBrushes();
            this.setBackgroundImage(control.backgroundImage.handle);
        } else {
            this.setBackgroundPixel(control.background == -1 ? control.defaultBackground() : control.background);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        int n = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n = color.handle;
        }
        if (n == this.background) {
            return;
        }
        this.background = n;
        this.updateBackgroundColor();
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        Shell shell = this.getShell();
        shell.releaseBrushes();
        this.updateBackgroundImage();
    }

    void setBackgroundImage(long l) {
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n = 1029;
            OS.RedrawWindow(this.handle, null, 0L, n);
        }
    }

    void setBackgroundPixel(int n) {
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n2 = 1029;
            OS.RedrawWindow(this.handle, null, 0L, n2);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = 52;
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), n5);
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.setBounds(n, n2, n3, n4, n5, true);
    }

    void setBounds(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (this.findImageControl() != null) {
            if (this.backgroundImage == null) {
                n5 |= 0x100;
            }
        } else if (OS.GetWindow(this.handle, 5) == 0L && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.findThemeControl() != null) {
            n5 |= 0x100;
        }
        long l = this.topHandle();
        if (bl && this.parent != null) {
            this.forceResize();
            if (this.parent.lpwp != null) {
                WINDOWPOS[] wINDOWPOSArray;
                int n6;
                WINDOWPOS[] wINDOWPOSArray2 = this.parent.lpwp;
                for (n6 = 0; n6 < wINDOWPOSArray2.length && wINDOWPOSArray2[n6] != null; ++n6) {
                }
                if (n6 == wINDOWPOSArray2.length) {
                    wINDOWPOSArray = new WINDOWPOS[wINDOWPOSArray2.length + 4];
                    System.arraycopy(wINDOWPOSArray2, 0, wINDOWPOSArray, 0, wINDOWPOSArray2.length);
                    wINDOWPOSArray2 = wINDOWPOSArray;
                    this.parent.lpwp = wINDOWPOSArray;
                }
                wINDOWPOSArray = new WINDOWPOS();
                wINDOWPOSArray.hwnd = l;
                wINDOWPOSArray.x = n;
                wINDOWPOSArray.y = n2;
                wINDOWPOSArray.cx = n3;
                wINDOWPOSArray.cy = n4;
                wINDOWPOSArray.flags = n5;
                wINDOWPOSArray2[n6] = wINDOWPOSArray;
                return;
            }
        }
        this.SetWindowPos(l, 0L, n, n2, n3, n4, n5);
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.SetCapture(this.handle);
        } else if (OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
    }

    void setCursor() {
        long l = OS.MAKELPARAM(1, 512);
        OS.SendMessage(this.handle, 32, this.handle, l);
    }

    public void setCursor(Cursor cursor) {
        Object object;
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (OS.IsWinCE) {
            long l = cursor != null ? cursor.handle : 0L;
            OS.SetCursor(l);
            return;
        }
        long l = OS.GetCapture();
        if (l == 0L) {
            object = new POINT();
            if (!OS.GetCursorPos((POINT)object)) {
                return;
            }
            long l2 = l = OS.WindowFromPoint((POINT)object);
            while (l2 != 0L && l2 != this.handle) {
                l2 = OS.GetParent(l2);
            }
            if (l2 == 0L) {
                return;
            }
        }
        if ((object = this.display.getControl(l)) == null) {
            object = this;
        }
        ((Control)object).setCursor();
    }

    void setDefaultFont() {
        long l = this.display.getSystemFont().handle;
        OS.SendMessage(this.handle, 48, l, 0L);
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x8000) : (this.state &= 0xFFFF7FFF);
        this.enableDrag(bl);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.enableWidget(bl);
        if (bl2) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        long l = 0L;
        if (font != null) {
            if (font.isDisposed()) {
                this.error(5);
            }
            l = font.handle;
        }
        this.font = font;
        if (l == 0L) {
            l = this.defaultFont();
        }
        OS.SendMessage(this.handle, 48, l, 1L);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        int n = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n = color.handle;
        }
        if (n == this.foreground) {
            return;
        }
        this.foreground = n;
        this.setForegroundPixel(n);
    }

    void setForegroundPixel(int n) {
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        int n3 = 21;
        if (!OS.IsWinCE) {
            n3 |= 0x20;
        }
        this.setBounds(n, n2, 0, 0, n3);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public void setOrientation(int n) {
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= 0xF7FFFFFF;
        this.style &= ~n2;
        this.style |= n & n2;
        this.style &= Integer.MAX_VALUE;
        this.updateOrientation();
        this.checkMirrored();
    }

    boolean setRadioFocus(boolean bl) {
        return false;
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        int n;
        this.checkWidget();
        if (this.drawCount == 0 && ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (bl) {
            if (--this.drawCount == 0) {
                long l = this.topHandle();
                OS.SendMessage(l, 11, 1L, 0L);
                if (this.handle != l) {
                    OS.SendMessage(this.handle, 11, 1L, 0L);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(l, 0);
                    if (this.handle != l) {
                        OS.ShowWindow(this.handle, 0);
                    }
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(l, null, true);
                    if (this.handle != l) {
                        OS.InvalidateRect(this.handle, null, true);
                    }
                } else {
                    int n2 = 1157;
                    OS.RedrawWindow(l, null, 0L, n2);
                }
            }
        } else if (this.drawCount++ == 0) {
            long l = this.topHandle();
            OS.SendMessage(l, 11, 0L, 0L);
            if (this.handle != l) {
                OS.SendMessage(this.handle, 11, 0L, 0L);
            }
        }
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        long l = 0L;
        if (region != null) {
            l = OS.CreateRectRgn(0, 0, 0, 0);
            OS.CombineRgn(l, region.handle, l, 2);
        }
        OS.SetWindowRgn(this.handle, l, true);
        this.region = region;
    }

    boolean setSavedFocus() {
        return this.forceFocus();
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        int n3 = 54;
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), n3);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int n) {
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        int n2 = 0x6000000;
        if ((n &= n2) == 0 || n == n2) {
            return;
        }
        if (this.updateTextDirection(n)) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.setToolTipText(this.getShell(), string);
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.handle, string);
    }

    public void setTouchEnabled(boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.RegisterTouchWindow(this.handle, 0);
        } else {
            OS.UnregisterTouchWindow(this.handle);
        }
    }

    public void setVisible(boolean bl) {
        int n;
        this.checkWidget();
        if (!this.getDrawing() ? (this.state & 0x10) == 0 == bl : ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000000) != 0 == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        if (!this.getDrawing()) {
            this.state = bl ? this.state & 0xFFFFFFEF : this.state | 0x10;
        } else {
            this.showWidget(bl);
            if (this.isDisposed()) {
                return;
            }
        }
        if (!bl) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (nArray[k] > nArray[k + i]) continue;
                    int n2 = nArray[k];
                    nArray[k] = nArray[k + i];
                    nArray[k + i] = n2;
                }
            }
        }
    }

    void subclass() {
        long l;
        long l2 = this.windowProc();
        if (l2 == (l = this.display.windowProc)) {
            return;
        }
        OS.SetWindowLongPtr(this.handle, -4, l);
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        OS.ScreenToClient(this.handle, pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        OS.ClientToScreen(this.handle, pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    long topHandle() {
        return this.handle;
    }

    boolean translateAccelerator(MSG mSG) {
        return this.menuShell().translateAccelerator(mSG);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(MSG mSG) {
        Decorations decorations;
        if (mSG.wParam < 32L) {
            return false;
        }
        long l = mSG.hwnd;
        if (OS.GetKeyState(18) >= 0) {
            long l2 = OS.SendMessage(l, 135, 0L, 0L);
            if ((l2 & 4L) != 0L) {
                return false;
            }
            if ((l2 & 0x2000L) == 0L) {
                return false;
            }
        }
        if ((decorations = this.menuShell()).isVisible() && decorations.isEnabled()) {
            this.display.lastAscii = (int)mSG.wParam;
            this.display.lastDead = false;
            this.display.lastNull = false;
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, 31, mSG.wParam, mSG.lParam)) {
                return this.translateMnemonic(event, null) || decorations.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG mSG) {
        long l = mSG.hwnd;
        int n = (int)mSG.wParam;
        if (n == 18) {
            if ((mSG.lParam & 0x40000000L) == 0L) {
                OS.SendMessage(l, 295, 3L, 0L);
            }
            return false;
        }
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = n;
        int n4 = 0;
        switch (n) {
            case 27: {
                bl2 = true;
                n4 = 27;
                long l2 = OS.SendMessage(l, 135, 0L, 0L);
                if ((l2 & 4L) != 0L && (l2 & 8L) == 0L) {
                    bl = false;
                }
                n2 = 2;
                break;
            }
            case 13: {
                bl2 = true;
                n4 = 13;
                long l3 = OS.SendMessage(l, 135, 0L, 0L);
                if ((l3 & 4L) != 0L) {
                    bl = false;
                }
                n2 = 4;
                break;
            }
            case 9: {
                n4 = 9;
                boolean bl4 = OS.GetKeyState(16) >= 0;
                long l4 = OS.SendMessage(l, 135, 0L, 0L);
                if ((l4 & 6L) != 0L) {
                    if ((l4 & 8L) != 0L) {
                        if (bl4 && OS.GetKeyState(17) >= 0) {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
                n2 = bl4 ? 16 : 8;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                boolean bl5;
                if (OS.IsSP && (n == 37 || n == 39)) {
                    return false;
                }
                bl3 = true;
                long l5 = OS.SendMessage(l, 135, 0L, 0L);
                if ((l5 & 1L) != 0L) {
                    bl = false;
                }
                boolean bl6 = bl5 = n == 40 || n == 39;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (n == 37 || n == 39)) {
                    bl5 = !bl5;
                }
                n2 = bl5 ? 64 : 32;
                break;
            }
            case 33: 
            case 34: {
                bl2 = true;
                bl3 = true;
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                long l6 = OS.SendMessage(l, 135, 0L, 0L);
                if ((l6 & 4L) != 0L && (l6 & 8L) == 0L) {
                    bl = false;
                }
                n2 = n == 33 ? 256 : 512;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = bl;
        event.detail = n2;
        this.display.lastKey = n3;
        this.display.lastAscii = n4;
        this.display.lastVirtual = bl3;
        this.display.lastDead = false;
        this.display.lastNull = false;
        if (!this.setKeyState(event, 31, mSG.wParam, mSG.lParam)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                OS.SendMessage(l, 295, 3L, 0L);
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl2 && control != null);
        return false;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    public boolean traverse(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(n, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int n, KeyEvent keyEvent) {
        this.checkWidget();
        if (keyEvent == null) {
            this.error(4);
        }
        return this.traverse(n, keyEvent.character, keyEvent.keyCode, keyEvent.keyLocation, keyEvent.stateMask, keyEvent.doit);
    }

    boolean traverse(int n, char c, int n2, int n3, int n4, boolean bl) {
        if (n == 0) {
            switch (n2) {
                case 27: {
                    n = 2;
                    bl = true;
                    break;
                }
                case 13: {
                    n = 4;
                    bl = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    n = 64;
                    bl = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 9: {
                    n = (n4 & 0x20000) != 0 ? 8 : 16;
                    bl = true;
                    break;
                }
                case 0x1000006: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 512;
                    bl = true;
                    break;
                }
                case 0x1000005: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 256;
                    bl = true;
                    break;
                }
                default: {
                    if (c == '\u0000' || (n4 & 0x50000) != 65536) break;
                    n = 128;
                    bl = true;
                }
            }
        }
        Event event = new Event();
        event.character = c;
        event.detail = n;
        event.doit = bl;
        event.keyCode = n2;
        event.keyLocation = n3;
        event.stateMask = n4;
        Shell shell = this.getShell();
        boolean bl2 = false;
        switch (n) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                bl2 = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                OS.SendMessage(this.handle, 295, 3L, 0L);
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl2 && control != null);
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        int n;
        int n2;
        Control control = this.computeTabRoot();
        Widget widget = this.computeTabGroup();
        Widget[] widgetArray = control.computeTabList();
        int n3 = widgetArray.length;
        for (n2 = 0; n2 < n3 && widgetArray[n2] != widget; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Widget widget2 = widgetArray[n2];
            if (widget2.isDisposed() || !widget2.setTabGroupFocus()) continue;
            return true;
        }
        if (widget.isDisposed()) {
            return false;
        }
        return widget.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl) {
        int n;
        int n2;
        Control[] controlArray = this.parent._getChildren();
        int n3 = controlArray.length;
        for (n2 = 0; n2 < n3 && controlArray[n2] != this; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char c) {
        if (this.mnemonicHit(c)) {
            OS.SendMessage(this.handle, 295, 3L, 0L);
            return true;
        }
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    void unsubclass() {
        long l = this.display.windowProc;
        long l2 = this.windowProc();
        if (l == l2) {
            return;
        }
        OS.SetWindowLongPtr(this.handle, -4, l2);
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean bl) {
        if (OS.IsWinCE) {
            OS.UpdateWindow(this.handle);
        } else {
            int n = 256;
            if (bl) {
                n |= 0x80;
            }
            OS.RedrawWindow(this.handle, null, 0L, n);
        }
    }

    void updateBackgroundColor() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        this.setBackgroundPixel(control.background);
    }

    void updateBackgroundImage() {
        Control control = this.findBackgroundControl();
        Image image = control != null ? control.backgroundImage : this.backgroundImage;
        this.setBackgroundImage(image != null ? image.handle : 0L);
    }

    void updateBackgroundMode() {
        int n = this.state & 0x400;
        this.checkBackground();
        if (n != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void updateFont(Font font, Font font2) {
        if (this.getFont().equals(font)) {
            this.setFont(font2);
        }
    }

    void updateImages() {
    }

    void updateLayout(boolean bl, boolean bl2) {
    }

    void updateOrientation() {
        int n = OS.GetWindowLong(this.handle, -20);
        n = (this.style & 0x4000000) != 0 ? (n |= 0x400000) : (n &= 0xFFBFFFFF);
        OS.SetWindowLong(this.handle, -20, n &= 0xFFFFDFFF);
        OS.InvalidateRect(this.handle, null, true);
    }

    boolean updateTextDirection(int n) {
        boolean bl;
        int n2;
        int n3 = OS.GetWindowLong(this.handle, -20);
        boolean bl2 = (n3 & (n2 = 0x402000)) != 0 && (n3 & n2) != n2;
        boolean bl3 = bl = n == 0x4000000;
        if (bl == bl2) {
            return false;
        }
        boolean bl4 = bl2 = (n3 & 0x400000) != 0;
        if (bl != bl2) {
            n3 |= 0x2000;
            this.style |= Integer.MIN_VALUE;
        } else {
            n3 &= 0xFFFFDFFF;
            this.style &= Integer.MAX_VALUE;
        }
        OS.SetWindowLong(this.handle, -20, n3);
        return true;
    }

    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    int widgetExtStyle() {
        int n = 0;
        if (!OS.IsPPC && (this.style & 0x800) != 0) {
            n |= 0x200;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return n;
        }
        n |= 0x100000;
        if ((this.style & 0x4000000) != 0) {
            n |= 0x400000;
        }
        if ((this.style & Integer.MIN_VALUE) != 0) {
            n |= 0x2000;
        }
        return n;
    }

    long widgetParent() {
        return this.parent.handle;
    }

    int widgetStyle() {
        int n = 0x54000000;
        if (OS.IsPPC && (this.style & 0x800) != 0) {
            n |= 0x800000;
        }
        return n;
    }

    public boolean setParent(Composite composite) {
        long l;
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            this.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        if (shell2 != shell || decorations2 != decorations) {
            Menu[] menuArray = shell2.findMenus(this);
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
        if (OS.SetParent(l = this.topHandle(), composite.handle) == 0L) {
            return false;
        }
        this.parent = composite;
        int n = 19;
        this.SetWindowPos(l, 1L, 0, 0, 0, 0, n);
        this.reskin(1);
        return true;
    }

    abstract TCHAR windowClass();

    abstract long windowProc();

    long windowProc(long l, int n, long l2, long l3) {
        LRESULT lRESULT = null;
        switch (n) {
            case 6: {
                lRESULT = this.WM_ACTIVATE(l2, l3);
                break;
            }
            case 533: {
                lRESULT = this.WM_CAPTURECHANGED(l2, l3);
                break;
            }
            case 295: {
                lRESULT = this.WM_CHANGEUISTATE(l2, l3);
                break;
            }
            case 258: {
                lRESULT = this.WM_CHAR(l2, l3);
                break;
            }
            case 771: {
                lRESULT = this.WM_CLEAR(l2, l3);
                break;
            }
            case 16: {
                lRESULT = this.WM_CLOSE(l2, l3);
                break;
            }
            case 273: {
                lRESULT = this.WM_COMMAND(l2, l3);
                break;
            }
            case 123: {
                lRESULT = this.WM_CONTEXTMENU(l2, l3);
                break;
            }
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: {
                lRESULT = this.WM_CTLCOLOR(l2, l3);
                break;
            }
            case 768: {
                lRESULT = this.WM_CUT(l2, l3);
                break;
            }
            case 2: {
                lRESULT = this.WM_DESTROY(l2, l3);
                break;
            }
            case 43: {
                lRESULT = this.WM_DRAWITEM(l2, l3);
                break;
            }
            case 22: {
                lRESULT = this.WM_ENDSESSION(l2, l3);
                break;
            }
            case 289: {
                lRESULT = this.WM_ENTERIDLE(l2, l3);
                break;
            }
            case 20: {
                lRESULT = this.WM_ERASEBKGND(l2, l3);
                break;
            }
            case 281: {
                lRESULT = this.WM_GESTURE(l2, l3);
                break;
            }
            case 135: {
                lRESULT = this.WM_GETDLGCODE(l2, l3);
                break;
            }
            case 49: {
                lRESULT = this.WM_GETFONT(l2, l3);
                break;
            }
            case 61: {
                lRESULT = this.WM_GETOBJECT(l2, l3);
                break;
            }
            case 36: {
                lRESULT = this.WM_GETMINMAXINFO(l2, l3);
                break;
            }
            case 83: {
                lRESULT = this.WM_HELP(l2, l3);
                break;
            }
            case 276: {
                lRESULT = this.WM_HSCROLL(l2, l3);
                break;
            }
            case 646: {
                lRESULT = this.WM_IME_CHAR(l2, l3);
                break;
            }
            case 271: {
                lRESULT = this.WM_IME_COMPOSITION(l2, l3);
                break;
            }
            case 269: {
                lRESULT = this.WM_IME_COMPOSITION_START(l2, l3);
                break;
            }
            case 270: {
                lRESULT = this.WM_IME_ENDCOMPOSITION(l2, l3);
                break;
            }
            case 279: {
                lRESULT = this.WM_INITMENUPOPUP(l2, l3);
                break;
            }
            case 81: {
                lRESULT = this.WM_INPUTLANGCHANGE(l2, l3);
                break;
            }
            case 786: {
                lRESULT = this.WM_HOTKEY(l2, l3);
                break;
            }
            case 256: {
                lRESULT = this.WM_KEYDOWN(l2, l3);
                break;
            }
            case 257: {
                lRESULT = this.WM_KEYUP(l2, l3);
                break;
            }
            case 8: {
                lRESULT = this.WM_KILLFOCUS(l2, l3);
                break;
            }
            case 515: {
                lRESULT = this.WM_LBUTTONDBLCLK(l2, l3);
                break;
            }
            case 513: {
                lRESULT = this.WM_LBUTTONDOWN(l2, l3);
                break;
            }
            case 514: {
                lRESULT = this.WM_LBUTTONUP(l2, l3);
                break;
            }
            case 521: {
                lRESULT = this.WM_MBUTTONDBLCLK(l2, l3);
                break;
            }
            case 519: {
                lRESULT = this.WM_MBUTTONDOWN(l2, l3);
                break;
            }
            case 520: {
                lRESULT = this.WM_MBUTTONUP(l2, l3);
                break;
            }
            case 44: {
                lRESULT = this.WM_MEASUREITEM(l2, l3);
                break;
            }
            case 288: {
                lRESULT = this.WM_MENUCHAR(l2, l3);
                break;
            }
            case 287: {
                lRESULT = this.WM_MENUSELECT(l2, l3);
                break;
            }
            case 33: {
                lRESULT = this.WM_MOUSEACTIVATE(l2, l3);
                break;
            }
            case 673: {
                lRESULT = this.WM_MOUSEHOVER(l2, l3);
                break;
            }
            case 675: {
                lRESULT = this.WM_MOUSELEAVE(l2, l3);
                break;
            }
            case 512: {
                lRESULT = this.WM_MOUSEMOVE(l2, l3);
                break;
            }
            case 522: {
                lRESULT = this.WM_MOUSEWHEEL(l2, l3);
                break;
            }
            case 526: {
                lRESULT = this.WM_MOUSEHWHEEL(l2, l3);
                break;
            }
            case 3: {
                lRESULT = this.WM_MOVE(l2, l3);
                break;
            }
            case 134: {
                lRESULT = this.WM_NCACTIVATE(l2, l3);
                break;
            }
            case 131: {
                lRESULT = this.WM_NCCALCSIZE(l2, l3);
                break;
            }
            case 132: {
                lRESULT = this.WM_NCHITTEST(l2, l3);
                break;
            }
            case 161: {
                lRESULT = this.WM_NCLBUTTONDOWN(l2, l3);
                break;
            }
            case 133: {
                lRESULT = this.WM_NCPAINT(l2, l3);
                break;
            }
            case 78: {
                lRESULT = this.WM_NOTIFY(l2, l3);
                break;
            }
            case 15: {
                lRESULT = this.WM_PAINT(l2, l3);
                break;
            }
            case 785: {
                lRESULT = this.WM_PALETTECHANGED(l2, l3);
                break;
            }
            case 528: {
                lRESULT = this.WM_PARENTNOTIFY(l2, l3);
                break;
            }
            case 770: {
                lRESULT = this.WM_PASTE(l2, l3);
                break;
            }
            case 791: {
                lRESULT = this.WM_PRINT(l2, l3);
                break;
            }
            case 792: {
                lRESULT = this.WM_PRINTCLIENT(l2, l3);
                break;
            }
            case 17: {
                lRESULT = this.WM_QUERYENDSESSION(l2, l3);
                break;
            }
            case 783: {
                lRESULT = this.WM_QUERYNEWPALETTE(l2, l3);
                break;
            }
            case 19: {
                lRESULT = this.WM_QUERYOPEN(l2, l3);
                break;
            }
            case 518: {
                lRESULT = this.WM_RBUTTONDBLCLK(l2, l3);
                break;
            }
            case 516: {
                lRESULT = this.WM_RBUTTONDOWN(l2, l3);
                break;
            }
            case 517: {
                lRESULT = this.WM_RBUTTONUP(l2, l3);
                break;
            }
            case 32: {
                lRESULT = this.WM_SETCURSOR(l2, l3);
                break;
            }
            case 7: {
                lRESULT = this.WM_SETFOCUS(l2, l3);
                break;
            }
            case 48: {
                lRESULT = this.WM_SETFONT(l2, l3);
                break;
            }
            case 26: {
                lRESULT = this.WM_SETTINGCHANGE(l2, l3);
                break;
            }
            case 11: {
                lRESULT = this.WM_SETREDRAW(l2, l3);
                break;
            }
            case 24: {
                lRESULT = this.WM_SHOWWINDOW(l2, l3);
                break;
            }
            case 5: {
                lRESULT = this.WM_SIZE(l2, l3);
                break;
            }
            case 262: {
                lRESULT = this.WM_SYSCHAR(l2, l3);
                break;
            }
            case 21: {
                lRESULT = this.WM_SYSCOLORCHANGE(l2, l3);
                break;
            }
            case 274: {
                lRESULT = this.WM_SYSCOMMAND(l2, l3);
                break;
            }
            case 260: {
                lRESULT = this.WM_SYSKEYDOWN(l2, l3);
                break;
            }
            case 261: {
                lRESULT = this.WM_SYSKEYUP(l2, l3);
                break;
            }
            case 715: {
                lRESULT = this.WM_TABLET_FLICK(l2, l3);
                break;
            }
            case 275: {
                lRESULT = this.WM_TIMER(l2, l3);
                break;
            }
            case 576: {
                lRESULT = this.WM_TOUCH(l2, l3);
                break;
            }
            case 772: {
                lRESULT = this.WM_UNDO(l2, l3);
                break;
            }
            case 293: {
                lRESULT = this.WM_UNINITMENUPOPUP(l2, l3);
                break;
            }
            case 296: {
                lRESULT = this.WM_UPDATEUISTATE(l2, l3);
                break;
            }
            case 277: {
                lRESULT = this.WM_VSCROLL(l2, l3);
                break;
            }
            case 71: {
                lRESULT = this.WM_WINDOWPOSCHANGED(l2, l3);
                break;
            }
            case 70: {
                lRESULT = this.WM_WINDOWPOSCHANGING(l2, l3);
                break;
            }
            case 525: {
                lRESULT = this.WM_XBUTTONDBLCLK(l2, l3);
                break;
            }
            case 523: {
                lRESULT = this.WM_XBUTTONDOWN(l2, l3);
                break;
            }
            case 524: {
                lRESULT = this.WM_XBUTTONUP(l2, l3);
            }
        }
        if (lRESULT != null) {
            return lRESULT.value;
        }
        return this.callWindowProc(l, n, l2, l3);
    }

    LRESULT WM_ACTIVATE(long l, long l2) {
        return null;
    }

    LRESULT WM_CAPTURECHANGED(long l, long l2) {
        return this.wmCaptureChanged(this.handle, l, l2);
    }

    LRESULT WM_CHANGEUISTATE(long l, long l2) {
        if ((this.state & 0x100000) != 0) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT WM_CHAR(long l, long l2) {
        return this.wmChar(this.handle, l, l2);
    }

    LRESULT WM_CLEAR(long l, long l2) {
        return null;
    }

    LRESULT WM_CLOSE(long l, long l2) {
        return null;
    }

    LRESULT WM_COMMAND(long l, long l2) {
        if (l2 == 0L) {
            int n;
            MenuItem menuItem;
            Decorations decorations = this.menuShell();
            if (decorations.isEnabled() && (menuItem = this.display.getMenuItem(n = OS.LOWORD(l))) != null && menuItem.isEnabled()) {
                return menuItem.wmCommandChild(l, l2);
            }
            return null;
        }
        Control control = this.display.getControl(l2);
        if (control == null) {
            return null;
        }
        return control.wmCommandChild(l, l2);
    }

    LRESULT WM_CONTEXTMENU(long l, long l2) {
        return this.wmContextMenu(this.handle, l, l2);
    }

    LRESULT WM_CTLCOLOR(long l, long l2) {
        Control control;
        long l3 = this.display.hPalette;
        if (l3 != 0L) {
            OS.SelectPalette(l, l3, false);
            OS.RealizePalette(l);
        }
        if ((control = this.display.getControl(l2)) == null) {
            return null;
        }
        return control.wmColorChild(l, l2);
    }

    LRESULT WM_CUT(long l, long l2) {
        return null;
    }

    LRESULT WM_DESTROY(long l, long l2) {
        return null;
    }

    LRESULT WM_DRAWITEM(long l, long l2) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, l2, DRAWITEMSTRUCT.sizeof);
        if (dRAWITEMSTRUCT.CtlType == 1) {
            MenuItem menuItem = this.display.getMenuItem(dRAWITEMSTRUCT.itemID);
            if (menuItem == null) {
                return null;
            }
            return menuItem.wmDrawChild(l, l2);
        }
        Control control = this.display.getControl(dRAWITEMSTRUCT.hwndItem);
        if (control == null) {
            return null;
        }
        return control.wmDrawChild(l, l2);
    }

    LRESULT WM_ENDSESSION(long l, long l2) {
        return null;
    }

    LRESULT WM_ENTERIDLE(long l, long l2) {
        return null;
    }

    LRESULT WM_ERASEBKGND(long l, long l2) {
        if ((this.state & 0x200) != 0 && this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.findThemeControl() != null) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_GESTURE(long l, long l2) {
        if (this.hooks(48) || this.filters(48)) {
            GESTUREINFO gESTUREINFO = new GESTUREINFO();
            gESTUREINFO.cbSize = GESTUREINFO.sizeof;
            if (OS.GetGestureInfo(l2, gESTUREINFO) && !this.sendGestureEvent(gESTUREINFO)) {
                OS.CloseGestureInfoHandle(l2);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT WM_GETDLGCODE(long l, long l2) {
        return null;
    }

    LRESULT WM_GETFONT(long l, long l2) {
        return null;
    }

    LRESULT WM_GETOBJECT(long l, long l2) {
        long l3;
        if (this.accessible != null && (l3 = this.accessible.internal_WM_GETOBJECT(l, l2)) != 0L) {
            return new LRESULT(l3);
        }
        return null;
    }

    LRESULT WM_GETMINMAXINFO(long l, long l2) {
        return null;
    }

    LRESULT WM_HOTKEY(long l, long l2) {
        return null;
    }

    LRESULT WM_HELP(long l, long l2) {
        if (OS.IsWinCE) {
            return null;
        }
        HELPINFO hELPINFO = new HELPINFO();
        OS.MoveMemory(hELPINFO, l2, HELPINFO.sizeof);
        Decorations decorations = this.menuShell();
        if (!decorations.isEnabled()) {
            return null;
        }
        if (hELPINFO.iContextType == 2) {
            MenuItem menuItem = this.display.getMenuItem(hELPINFO.iCtrlId);
            if (menuItem != null && menuItem.isEnabled()) {
                Widget widget = null;
                if (menuItem.hooks(28)) {
                    widget = menuItem;
                } else {
                    Menu menu = menuItem.parent;
                    if (menu.hooks(28)) {
                        widget = menu;
                    }
                }
                if (widget != null) {
                    long l3 = decorations.handle;
                    OS.SendMessage(l3, 31, 0L, 0L);
                    widget.postEvent(28);
                    return LRESULT.ONE;
                }
            }
            return null;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_HSCROLL(long l, long l2) {
        Control control = this.display.getControl(l2);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(l, l2);
    }

    LRESULT WM_IME_CHAR(long l, long l2) {
        return this.wmIMEChar(this.handle, l, l2);
    }

    LRESULT WM_IME_COMPOSITION(long l, long l2) {
        return null;
    }

    LRESULT WM_IME_COMPOSITION_START(long l, long l2) {
        return null;
    }

    LRESULT WM_IME_ENDCOMPOSITION(long l, long l2) {
        return null;
    }

    LRESULT WM_UNINITMENUPOPUP(long l, long l2) {
        Menu menu = this.menuShell().findMenu(l);
        if (menu != null) {
            Shell shell = this.getShell();
            menu.sendEvent(23);
            if (menu == shell.activeMenu) {
                shell.activeMenu = null;
            }
        }
        return null;
    }

    LRESULT WM_INITMENUPOPUP(long l, long l2) {
        Menu menu;
        if (this.display.accelKeyHit) {
            return null;
        }
        Shell shell = this.getShell();
        Menu menu2 = shell.activeMenu;
        Menu menu3 = null;
        if (OS.HIWORD(l2) == 0 && (menu3 = this.menuShell().findMenu(l)) != null) {
            menu3.update();
        }
        for (menu = menu3; menu != null && menu != menu2; menu = menu.getParentMenu()) {
        }
        if (menu == null) {
            menu = shell.activeMenu;
            while (menu != null) {
                Menu menu4;
                menu.sendEvent(23);
                if (menu.isDisposed()) break;
                menu = menu.getParentMenu();
                for (menu4 = menu3; menu4 != null && menu4 != menu; menu4 = menu4.getParentMenu()) {
                }
                if (menu4 == null) continue;
                break;
            }
        }
        if (menu3 != null && menu3.isDisposed()) {
            menu3 = null;
        }
        shell.activeMenu = menu3;
        if (menu3 != null && menu3 != menu2) {
            menu3.sendEvent(22);
        }
        return null;
    }

    LRESULT WM_INPUTLANGCHANGE(long l, long l2) {
        this.menuShell().destroyAccelerators();
        return null;
    }

    LRESULT WM_KEYDOWN(long l, long l2) {
        return this.wmKeyDown(this.handle, l, l2);
    }

    LRESULT WM_KEYUP(long l, long l2) {
        return this.wmKeyUp(this.handle, l, l2);
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        return this.wmKillFocus(this.handle, l, l2);
    }

    LRESULT WM_LBUTTONDBLCLK(long l, long l2) {
        return this.wmLButtonDblClk(this.handle, l, l2);
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        return this.wmLButtonDown(this.handle, l, l2);
    }

    LRESULT WM_LBUTTONUP(long l, long l2) {
        return this.wmLButtonUp(this.handle, l, l2);
    }

    LRESULT WM_MBUTTONDBLCLK(long l, long l2) {
        return this.wmMButtonDblClk(this.handle, l, l2);
    }

    LRESULT WM_MBUTTONDOWN(long l, long l2) {
        return this.wmMButtonDown(this.handle, l, l2);
    }

    LRESULT WM_MBUTTONUP(long l, long l2) {
        return this.wmMButtonUp(this.handle, l, l2);
    }

    LRESULT WM_MEASUREITEM(long l, long l2) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, l2, MEASUREITEMSTRUCT.sizeof);
        if (mEASUREITEMSTRUCT.CtlType == 1) {
            MenuItem menuItem = this.display.getMenuItem(mEASUREITEMSTRUCT.itemID);
            if (menuItem == null) {
                return null;
            }
            return menuItem.wmMeasureChild(l, l2);
        }
        long l3 = OS.GetDlgItem(this.handle, mEASUREITEMSTRUCT.CtlID);
        Control control = this.display.getControl(l3);
        if (control == null) {
            return null;
        }
        return control.wmMeasureChild(l, l2);
    }

    LRESULT WM_MENUCHAR(long l, long l2) {
        int n = OS.HIWORD(l);
        if (n == 0 || n == 8192) {
            this.display.mnemonicKeyHit = false;
            return new LRESULT(OS.MAKELRESULT(0, 1));
        }
        return null;
    }

    LRESULT WM_MENUSELECT(long l, long l2) {
        int n = OS.HIWORD(l);
        Shell shell = this.getShell();
        if (n == 65535 && l2 == 0L) {
            for (Menu menu = shell.activeMenu; menu != null; menu = menu.getParentMenu()) {
                this.display.mnemonicKeyHit = true;
                menu.sendEvent(23);
                if (menu.isDisposed()) break;
            }
            shell.activeMenu = null;
            return null;
        }
        if ((n & 0x2000) != 0) {
            return null;
        }
        if ((n & 0x80) != 0) {
            Widget widget = null;
            Decorations decorations = this.menuShell();
            if ((n & 0x10) != 0) {
                Menu menu;
                int n2 = OS.LOWORD(l);
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 4;
                if (OS.GetMenuItemInfo(l2, n2, true, mENUITEMINFO) && (menu = decorations.findMenu(mENUITEMINFO.hSubMenu)) != null) {
                    widget = menu.cascade;
                }
            } else {
                Menu menu = decorations.findMenu(l2);
                if (menu != null) {
                    int n3 = OS.LOWORD(l);
                    widget = this.display.getMenuItem(n3);
                }
            }
            if (widget != null) {
                widget.sendEvent(30);
            }
        }
        return null;
    }

    LRESULT WM_MOUSEACTIVATE(long l, long l2) {
        return null;
    }

    LRESULT WM_MOUSEHOVER(long l, long l2) {
        return this.wmMouseHover(this.handle, l, l2);
    }

    LRESULT WM_MOUSELEAVE(long l, long l2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            this.getShell().fixToolTip();
        }
        return this.wmMouseLeave(this.handle, l, l2);
    }

    LRESULT WM_MOUSEMOVE(long l, long l2) {
        return this.wmMouseMove(this.handle, l, l2);
    }

    LRESULT WM_MOUSEWHEEL(long l, long l2) {
        return this.wmMouseWheel(this.handle, l, l2);
    }

    LRESULT WM_MOUSEHWHEEL(long l, long l2) {
        return this.wmMouseHWheel(this.handle, l, l2);
    }

    LRESULT WM_MOVE(long l, long l2) {
        this.state |= 0x10000;
        if (this.findImageControl() != null) {
            if (this != this.getShell()) {
                this.redrawChildren();
            }
        } else if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && OS.IsWindowVisible(this.handle) && this.findThemeControl() != null) {
            this.redrawChildren();
        }
        if ((this.state & 0x20000) == 0) {
            this.sendEvent(10);
        }
        return null;
    }

    LRESULT WM_NCACTIVATE(long l, long l2) {
        return null;
    }

    LRESULT WM_NCCALCSIZE(long l, long l2) {
        return null;
    }

    LRESULT WM_NCHITTEST(long l, long l2) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isActive()) {
            return new LRESULT(-1L);
        }
        return null;
    }

    LRESULT WM_NCLBUTTONDOWN(long l, long l2) {
        return null;
    }

    LRESULT WM_NCPAINT(long l, long l2) {
        return this.wmNCPaint(this.handle, l, l2);
    }

    LRESULT WM_NOTIFY(long l, long l2) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory(nMHDR, l2, NMHDR.sizeof);
        return this.wmNotify(nMHDR, l, l2);
    }

    LRESULT WM_PAINT(long l, long l2) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        return this.wmPaint(this.handle, l, l2);
    }

    LRESULT WM_PALETTECHANGED(long l, long l2) {
        return null;
    }

    LRESULT WM_PARENTNOTIFY(long l, long l2) {
        return null;
    }

    LRESULT WM_PASTE(long l, long l2) {
        return null;
    }

    LRESULT WM_PRINT(long l, long l2) {
        return this.wmPrint(this.handle, l, l2);
    }

    LRESULT WM_PRINTCLIENT(long l, long l2) {
        return null;
    }

    LRESULT WM_QUERYENDSESSION(long l, long l2) {
        return null;
    }

    LRESULT WM_QUERYNEWPALETTE(long l, long l2) {
        return null;
    }

    LRESULT WM_QUERYOPEN(long l, long l2) {
        return null;
    }

    LRESULT WM_RBUTTONDBLCLK(long l, long l2) {
        return this.wmRButtonDblClk(this.handle, l, l2);
    }

    LRESULT WM_RBUTTONDOWN(long l, long l2) {
        return this.wmRButtonDown(this.handle, l, l2);
    }

    LRESULT WM_RBUTTONUP(long l, long l2) {
        return this.wmRButtonUp(this.handle, l, l2);
    }

    LRESULT WM_SETCURSOR(long l, long l2) {
        short s = (short)OS.LOWORD(l2);
        if (s == 1) {
            Control control = this.display.getControl(l);
            if (control == null) {
                return null;
            }
            Cursor cursor = control.findCursor();
            if (cursor != null) {
                OS.SetCursor(cursor.handle);
                return LRESULT.ONE;
            }
        }
        return null;
    }

    LRESULT WM_SETFOCUS(long l, long l2) {
        return this.wmSetFocus(this.handle, l, l2);
    }

    LRESULT WM_SETTINGCHANGE(long l, long l2) {
        return null;
    }

    LRESULT WM_SETFONT(long l, long l2) {
        return null;
    }

    LRESULT WM_SETREDRAW(long l, long l2) {
        return null;
    }

    LRESULT WM_SHOWWINDOW(long l, long l2) {
        return null;
    }

    LRESULT WM_SIZE(long l, long l2) {
        this.state |= 0x40000;
        if ((this.state & 0x80000) == 0) {
            this.sendEvent(11);
        }
        return null;
    }

    LRESULT WM_SYSCHAR(long l, long l2) {
        return this.wmSysChar(this.handle, l, l2);
    }

    LRESULT WM_SYSCOLORCHANGE(long l, long l2) {
        return null;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    LRESULT WM_SYSCOMMAND(long l, long l2) {
        Decorations decorations;
        if ((l & 0xF000L) == 0L) {
            Decorations decorations2 = this.menuShell();
            if (!decorations2.isEnabled()) return LRESULT.ZERO;
            MenuItem menuItem = this.display.getMenuItem(OS.LOWORD(l));
            if (menuItem == null) return LRESULT.ZERO;
            menuItem.wmCommandChild(l, l2);
            return LRESULT.ZERO;
        }
        int n = (int)l & 0xFFF0;
        int n2 = 0;
        block6: do {
            switch (n2 == 0 ? n : n2) {
                case 61536: {
                    long l3 = this.menuShell().handle;
                    int n3 = OS.GetWindowLong(l3, -16);
                    if ((n3 & 0x80000) != 0) return null;
                    return LRESULT.ZERO;
                }
                case 61696: {
                    int n4;
                    MenuItem[] menuItemArray;
                    char c2;
                    if (l2 == 0L) {
                        n2 = 61552;
                        decorations = this.menuShell();
                        Menu menu = decorations.getMenuBar();
                        if (menu != null) continue block6;
                        n2 = 61552;
                        Control control = this.display._getFocusControl();
                        if (control == null) continue block6;
                        if (!control.hooks(1)) {
                            n2 = 61552;
                            if (!control.hooks(2)) continue block6;
                        }
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    if (!this.hooks(1)) {
                        n2 = 61552;
                        if (!this.hooks(2)) continue block6;
                    }
                    n2 = 61552;
                    if (l2 == 32L) continue block6;
                    decorations = this.menuShell();
                    Menu menu = decorations.getMenuBar();
                    if (menu != null) {
                        n2 = 61552;
                        c2 = Display.mbcsToWcs((int)l2);
                        if (c2 == '\u0000') continue block6;
                        c2 = Character.toUpperCase(c2);
                        menuItemArray = menu.getItems();
                        n4 = 0;
                    } else {
                        this.display.mnemonicKeyHit = false;
                        n2 = 61552;
                        continue block6;
                    }
                }
                case 61472: {
                    this.menuShell().saveFocus();
                    return null;
                }
                default: {
                    return null;
                }
                while (true) {
                    char c;
                    int n4;
                    MenuItem[] menuItemArray;
                    char c2;
                    n2 = 61552;
                    if (n4 >= menuItemArray.length) continue block6;
                    MenuItem menuItem = menuItemArray[n4];
                    String string = menuItem.getText();
                    char c3 = this.findMnemonic(string);
                    if (string.length() > 0 && c3 == '\u0000' && Character.toUpperCase(c = string.charAt(0)) == c2) {
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    ++n4;
                }
                case 61552: 
                case 61568: 
            }
            break;
        } while (true);
        decorations = this.menuShell();
        if (!decorations.isEnabled()) return LRESULT.ZERO;
        if (decorations.isActive()) return null;
        return LRESULT.ZERO;
    }

    LRESULT WM_SYSKEYDOWN(long l, long l2) {
        return this.wmSysKeyDown(this.handle, l, l2);
    }

    LRESULT WM_SYSKEYUP(long l, long l2) {
        return this.wmSysKeyUp(this.handle, l, l2);
    }

    LRESULT WM_TABLET_FLICK(long l, long l2) {
        if (!this.hooks(48) && !this.filters(48)) {
            return null;
        }
        Event event = new Event();
        FLICK_DATA fLICK_DATA = new FLICK_DATA();
        long[] lArray = new long[]{l};
        OS.MoveMemory(fLICK_DATA, lArray, OS.FLICK_DATA_sizeof());
        FLICK_POINT fLICK_POINT = new FLICK_POINT();
        lArray[0] = l2;
        OS.MoveMemory(fLICK_POINT, lArray, OS.FLICK_POINT_sizeof());
        switch (fLICK_DATA.iFlickDirection) {
            case 0: {
                event.xDirection = 1;
                event.yDirection = 0;
                break;
            }
            case 1: {
                event.xDirection = 1;
                event.yDirection = -1;
                break;
            }
            case 2: {
                event.xDirection = 0;
                event.yDirection = -1;
                break;
            }
            case 3: {
                event.xDirection = -1;
                event.yDirection = -1;
                break;
            }
            case 4: {
                event.xDirection = -1;
                event.yDirection = 0;
                break;
            }
            case 5: {
                event.xDirection = -1;
                event.yDirection = 1;
                break;
            }
            case 6: {
                event.xDirection = 0;
                event.yDirection = 1;
                break;
            }
            case 7: {
                event.xDirection = 1;
                event.yDirection = 1;
            }
        }
        event.x = fLICK_POINT.x;
        event.y = fLICK_POINT.y;
        event.type = 48;
        event.detail = 16;
        this.setInputState(event, 48);
        this.sendEvent(48, event);
        return event.doit ? null : LRESULT.ONE;
    }

    LRESULT WM_TOUCH(long l, long l2) {
        LRESULT lRESULT = null;
        if (this.hooks(47) || this.filters(47)) {
            int n = OS.LOWORD(l);
            long l3 = OS.GetProcessHeap();
            long l4 = OS.HeapAlloc(l3, 8, n * TOUCHINPUT.sizeof);
            if (l4 != 0L) {
                if (OS.GetTouchInputInfo(l2, n, l4, TOUCHINPUT.sizeof)) {
                    TOUCHINPUT[] tOUCHINPUTArray = new TOUCHINPUT[n];
                    for (int i = 0; i < n; ++i) {
                        tOUCHINPUTArray[i] = new TOUCHINPUT();
                        OS.MoveMemory(tOUCHINPUTArray[i], l4 + (long)(i * TOUCHINPUT.sizeof), TOUCHINPUT.sizeof);
                    }
                    this.sendTouchEvent(tOUCHINPUTArray);
                    OS.CloseTouchInputHandle(l2);
                    lRESULT = LRESULT.ZERO;
                }
                OS.HeapFree(l3, 0, l4);
            }
        }
        return lRESULT;
    }

    LRESULT WM_TIMER(long l, long l2) {
        return null;
    }

    LRESULT WM_UNDO(long l, long l2) {
        return null;
    }

    LRESULT WM_UPDATEUISTATE(long l, long l2) {
        return null;
    }

    LRESULT WM_VSCROLL(long l, long l2) {
        Control control = this.display.getControl(l2);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LRESULT WM_WINDOWPOSCHANGED(long l, long l2) {
        try {
            ++this.display.resizeCount;
            long l3 = this.callWindowProc(this.handle, 71, l, l2);
            LRESULT lRESULT = l3 == 0L ? LRESULT.ZERO : new LRESULT(l3);
            return lRESULT;
        }
        finally {
            --this.display.resizeCount;
        }
    }

    LRESULT WM_WINDOWPOSCHANGING(long l, long l2) {
        Shell shell;
        if (!this.getDrawing() && (shell = this.getShell()) != this) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, l2, WINDOWPOS.sizeof);
            if ((wINDOWPOS.flags & 2) == 0 || (wINDOWPOS.flags & 1) == 0) {
                RECT rECT = new RECT();
                OS.GetWindowRect(this.topHandle(), rECT);
                int n = rECT.right - rECT.left;
                int n2 = rECT.bottom - rECT.top;
                if (n != 0 && n2 != 0) {
                    long l3 = this.parent == null ? 0L : this.parent.handle;
                    OS.MapWindowPoints(0L, l3, rECT, 2);
                    if (OS.IsWinCE) {
                        OS.InvalidateRect(l3, rECT, true);
                    } else {
                        long l4 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                        long l5 = OS.CreateRectRgn(wINDOWPOS.x, wINDOWPOS.y, wINDOWPOS.x + wINDOWPOS.cx, wINDOWPOS.y + wINDOWPOS.cy);
                        OS.CombineRgn(l4, l4, l5, 4);
                        int n3 = 1157;
                        OS.RedrawWindow(l3, null, l4, n3);
                        OS.DeleteObject(l4);
                        OS.DeleteObject(l5);
                    }
                }
            }
        }
        return null;
    }

    LRESULT WM_XBUTTONDBLCLK(long l, long l2) {
        return this.wmXButtonDblClk(this.handle, l, l2);
    }

    LRESULT WM_XBUTTONDOWN(long l, long l2) {
        return this.wmXButtonDown(this.handle, l, l2);
    }

    LRESULT WM_XBUTTONUP(long l, long l2) {
        return this.wmXButtonUp(this.handle, l, l2);
    }

    LRESULT wmColorChild(long l, long l2) {
        Control control = this.findBackgroundControl();
        if (control == null) {
            if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
                RECT rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                OS.SetTextColor(l, this.getForegroundPixel());
                OS.SetBkColor(l, this.getBackgroundPixel());
                this.fillThemeBackground(l, control, rECT);
                OS.SetBkMode(l, 1);
                return new LRESULT(OS.GetStockObject(5));
            }
            if (this.foreground == -1) {
                return null;
            }
        }
        if (control == null) {
            control = this;
        }
        int n = this.getForegroundPixel();
        int n2 = control.getBackgroundPixel();
        OS.SetTextColor(l, n);
        OS.SetBkColor(l, n2);
        if (control.backgroundImage != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            long l3 = control.handle;
            long l4 = control.backgroundImage.handle;
            OS.MapWindowPoints(this.handle, l3, rECT, 2);
            POINT pOINT = new POINT();
            OS.GetWindowOrgEx(l, pOINT);
            OS.SetBrushOrgEx(l, -rECT.left - pOINT.x, -rECT.top - pOINT.y, pOINT);
            long l5 = this.findBrush(l4, 3);
            if ((this.state & 0x200) != 0) {
                long l6 = OS.SelectObject(l, l5);
                OS.MapWindowPoints(l3, this.handle, rECT, 2);
                OS.PatBlt(l, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                OS.SelectObject(l, l6);
            }
            OS.SetBkMode(l, 1);
            return new LRESULT(l5);
        }
        long l7 = this.findBrush(n2, 0);
        if ((this.state & 0x200) != 0) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            long l8 = OS.SelectObject(l, l7);
            OS.PatBlt(l, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
            OS.SelectObject(l, l8);
        }
        return new LRESULT(l7);
    }

    LRESULT wmCommandChild(long l, long l2) {
        return null;
    }

    LRESULT wmDrawChild(long l, long l2) {
        return null;
    }

    LRESULT wmMeasureChild(long l, long l2) {
        return null;
    }

    LRESULT wmNotify(NMHDR nMHDR, long l, long l2) {
        Control control = this.display.getControl(nMHDR.hwndFrom);
        if (control == null) {
            return null;
        }
        return control.wmNotifyChild(nMHDR, l, l2);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, long l, long l2) {
        return null;
    }

    LRESULT wmScrollChild(long l, long l2) {
        return null;
    }
}

