import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;


public class AddIco {

	public static final String OS_NAME = System.getProperty("os.name");
	public static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
	public static final boolean IS_LINUX = OS_NAME.startsWith("Linux");
	public static final boolean IS_OSX = OS_NAME.startsWith("Mac OS");
	public static final String OS_ARCH = System.getProperty("os.arch");
	public static final String JVM_ARCH = System.getProperty("sun.arch.data.model");
	
	public static void main(final String[] args) {
    	// load the appropriate SWT JAR for the architecture
    	loadSWT();
		new AddIcoImpl(args);
    }

	public static void loadSWT() {
		try {
			File file = null;
			if (IS_WINDOWS) {
				file = new File("swtwin32.jar"); // x86
				if (JVM_ARCH.equals("64")) {
					file = new File("swtwin64.jar"); // x64
				}
			} else if (IS_OSX) {
				file = new File("swtmac32.jar"); // x86
				if (JVM_ARCH.equals("64")) {
					file = new File("swtmac64.jar"); // x64
				} else if (OS_ARCH.startsWith("ppc")) {
					file = new File("swtmaccb.jar"); // carbon
				}
			} else if (IS_LINUX) {
				file = new File("swtlin32.jar"); // x86
				if (JVM_ARCH.equals("64")) {
					file = new File("swtlin64.jar"); // x64
				}
			}

			Method method = URLClassLoader.class.getDeclaredMethod("addURL", new Class[] { URL.class });
			method.setAccessible(true);
			method.invoke(ClassLoader.getSystemClassLoader(), new Object[] { file.toURI().toURL() });

		} catch (Exception e) {
            e.printStackTrace();
        }
	}
}
