import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;


public class AddIcoImpl {

	private final static int ICON_SIZE = 32;
	private final static byte[] ICON_HEADER = { 0x1F, 0x0, 0x1F, 0x0 };
	
	
	public AddIcoImpl(String[] args) {
		System.out.println("Access AddIco for Access V4.00 and up\n");
		
		if (args.length < 2) {
			System.out.println("To add icons to Access' icon-library:\n\tjava AddIco <.ico file or directory> <iconlib>\n");
			System.out.println("For example:\n\tjava AddIco c:\\ico\\game.ico c:\\xx\\iconlib.xx");
			System.exit(1);
		}
		
		ImageLoader imgLoader = new ImageLoader();
		
		System.out.println("Opening " + args[1] + " ...");
		FileOutputStream stream = null;
		try {
			stream = new FileOutputStream(args[1], true);
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
			System.exit(1);
		}
		
		File[] files;
		File fileOrDir = new File(args[0]);
		if (fileOrDir.isDirectory()) {
			files = fileOrDir.listFiles();
		} else {
			files = new File[] { new File(args[0]) };
		}
		
		for (File f: files) {
			System.out.println("Processing " + f.getPath() + "...");
			ImageData[] data = null;
			try {
				data = imgLoader.load(f.getPath());
			} catch (SWTException e) {
				System.err.println("SWT cannnot process this file: " + e.getMessage());
				continue;
			}
			
			for (int frameNr = 0; frameNr < data.length; frameNr++) {
				ImageData img = data[frameNr];
				System.out.println("Frame " + (frameNr + 1) + " of " + data.length + ", size:" + img.width + "x" + img.height + "  bpp:" + img.depth + "  Direct palette:" + img.palette.isDirect);
				
				if (img.width != img.height) {
					System.err.println("Icon is not square (width != height), skipping...");
					continue;
				}
				
				if (img.width != ICON_SIZE)
					img = img.scaledTo(ICON_SIZE, ICON_SIZE);
				
				ImageData mask = img.getTransparencyMask();
				
				try {
					stream.write(ICON_HEADER);
					
					for (int y = 0; y < ICON_SIZE; y++) {
						for (int x = 0; x < ICON_SIZE; x++) {
							int pixel = img.getPixel(x, y);
							RGB rgb = img.palette.getRGB(pixel);
							byte r = (byte) ((rgb.red / 64) * 16);
							byte g = (byte) ((rgb.green / 64) * 4);
							byte b = (byte) ((rgb.blue / 64) * 1);
							byte col = (byte) (r + g + b);
							if (mask.getPixel(x,  y) == 0)
								stream.write(0xFF);
							else
								stream.write(col);
						}
					}
			    	System.out.println("Added frame " + (frameNr + 1));
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		
		System.out.println("Closing " + args[1] + "...");
		try {
			stream.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		System.out.println("Done.");
	}
}
